#!/usr/bin/python
#dv3d_io_autoScript.py
#Automatic processing of i/o for images / movies
#DV3D refactor 2
#AG 22/01/2013

''' 
Form the main script, type holders are:

    #the main data type holders
    tpw.Planes = []
    tpw.Volumes = []
    tpw.Surfaces = []
    tpw.SurfaceGroups = []
    tpw.Markers = []
    tpw.Lights = []

'''


import dv3d_gui_Callbacks as cb
import time
import vtk

from dv3d_vtkTools_generateVTKSurface import *
from numpy import *


def writeImage(imageCounter, renderWindow):
    #write an image out to file
    windowToImageFilter = vtk.vtkWindowToImageFilter()
    windowToImageFilter.SetInput(renderWindow)
    windowToImageFilter.SetMagnification(1) #set the resolution of the output image (1x times the current resolution of vtk render window)
    windowToImageFilter.SetInputBufferTypeToRGBA() #also record the alpha (transparency) channel
    windowToImageFilter.Update()

    writer = vtk.vtkTIFFWriter()
    writer.SetCompressionToNoCompression()
    writer.SetFileName('/tmp/frame%05d.tiff' %imageCounter)
    writer.SetInputConnection(windowToImageFilter.GetOutputPort())
    writer.Write()


def runAutoScripts(the_parent_window):
    #test code for extracting image plane coordinates
    print 'executing auto script'

    tpw = the_parent_window #for brevity

    # get the base planes   
    xp = tpw.Planes[0].planeWidget_3dX
    yp = tpw.Planes[0].planeWidget_3dY
    zp = tpw.Planes[0].planeWidget_3dZ

    myBounds = xp.GetInput().GetBounds()
    
    scaleSphere = vtk.vtkSphereSource()
    scaleSphere.SetCenter(myBounds[1],myBounds[3],myBounds[5])
    scaleSphere.SetRadius(5.0)
    scaleSphere.SetPhiResolution(100)  
    scaleSphere.SetThetaResolution(100)

    scaleMapper = vtk.vtkPolyDataMapper()
    scaleMapper.SetInput(scaleSphere.GetOutput())

    scaleActor = vtk.vtkActor()
    scaleActor.SetMapper(scaleMapper)

    yy = scaleActor.GetProperty()
    yy.SetShading(0)
    yy.SetSpecularPower(0)
    yy.SetAmbient(0)
    yy.SetLighting(0)

    tpw.ren3d.AddActor(scaleActor)
    tpw.ren3d.Render()






