#!/usr/bin/python
#dv3d_io_autoScript.py
#Automatic processing of i/o for images / movies
#DV3D refactor 2
#AG 22/01/2013

''' 
Form the main script, type holders are:

    #the main data type holders
    tpw.Planes = []
    tpw.Volumes = []
    tpw.Surfaces = []
    tpw.SurfaceGroups = []
    tpw.Markers = []
    tpw.Lights = []

'''


import dv3d_gui_Callbacks as cb
import time
import vtk

from dv3d_vtkTools_generateVTKSurface import *
from numpy import *


def writeImage(imageCounter, renderWindow):
    #write an image out to file
    windowToImageFilter = vtk.vtkWindowToImageFilter()
    windowToImageFilter.SetInput(renderWindow)
    windowToImageFilter.SetMagnification(1) #set the resolution of the output image (1x times the current resolution of vtk render window)
    windowToImageFilter.SetInputBufferTypeToRGBA() #also record the alpha (transparency) channel
    windowToImageFilter.Update()

    writer = vtk.vtkTIFFWriter()
    writer.SetCompressionToNoCompression()
    writer.SetFileName('/tmp/frame%05d.tiff' %imageCounter)
    writer.SetInputConnection(windowToImageFilter.GetOutputPort())
    writer.Write()


def runAutoScripts(the_parent_window):
    #pass # for now
    print 'executing auto script'

    tpw = the_parent_window #for brevity

    # change background colour
    tpw.ren3d.SetBackground(1,1,1)

    # load base fmri Volume
    cb.cb_LoadDataForPlanes(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/MNI_structural.nii.gz")
    planes1 = tpw.Planes[-1]    

    # load base fmri Volume
    cb.cb_LoadDataForPlanes(tpw, "/groups/Projects/P1062/Andre/Overlay1_midres.nii.gz")
    planes1 = tpw.Planes[-1]    

    # load base fmri Volume
    cb.cb_LoadDataForPlanes(tpw, "/groups/Projects/P1062/Andre/Overlay2_midres.nii.gz")
    planes1 = tpw.Planes[-1]    

    # load cortex
    #cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/Cortex_3mm.vtk")
    cb.cb_LoadDataForSurface(tpw, "/home/andre/andre_svn/trunk/DV3D_BetaDist/DV3D_v0.551/DV3D_essentials/mni_surface_145_05mm_x3.vtk")
    cortex = tpw.Surfaces[-1]
    #change appearance
    cortex.GetProperty().SetRepresentationToWireframe()
    cortex.GetProperty().SetOpacity(0.025)
    cortex.GetProperty().SetColor(0.85,0.85,0.85)    





    #stat1 form overlay 1
    #generateGroupSurfaces(tpw, 1, extractionVals, opacityVals, colHueVals, surfacesToGetIndex, smoothingIterations, decimationFactor, samplingFrequency)
    #generateGroupSurfaces(tpw, 1, linspace(2.48,2.59,6), [0.18,0.18,0.18,0.18,0.18,1.0], linspace(0,0.166666666,6), 0, 100, 0, 1)
    #stat1 = tpw.SurfaceGroups[-1]

    #inverse stat1 form overlay 1
    #generateGroupSurfaces(tpw, 1, linspace(-2.48,-2.59,6), [0.18,0.18,0.18,0.18,0.18,1.0], linspace(0.6666666,0.33333,6), 0, 100, 0, 1)
    #stat2 = tpw.SurfaceGroups[-1]

    #stat2 form overlay 2
    #generateGroupSurfaces(tpw, 1, extractionVals, opacityVals, colHueVals, surfacesToGetIndex, smoothingIterations, decimationFactor, samplingFrequency)
    generateGroupSurfaces(tpw, 2, linspace(2.48,2.59,6), [0.18,0.18,0.18,0.18,0.18,1.0], linspace(0,0.166666666,6), 0, 100, 0, 1)
    stat1 = tpw.SurfaceGroups[-1]

    #inverse stat2 form overlay 2
    generateGroupSurfaces(tpw, 2, linspace(-5.48,-13,6), [0.18,0.18,0.18,0.18,0.18,1.0], linspace(0.6666666,0.33333,6), 0, 100, 0, 1)
    stat2 = tpw.SurfaceGroups[-1]


    camera = tpw.ren3d.GetActiveCamera()
    renWin = tpw.ren3d.GetRenderWindow()



'''
then run:
ffmpeg -r 25 -i /tmp/frame%05d.tiff -vb 10000k /tmp/video.mpg
'''


   

