#!/usr/bin/python
#dv3d_io_autoScript.py
#Automatic processing of i/o for images / movies
#DV3D refactor 2
#AG 22/01/2013

''' 
Form the main script, type holders are:

    #the main data type holders
    tpw.Planes = []
    tpw.Volumes = []
    tpw.Surfaces = []
    tpw.SurfaceGroups = []
    tpw.Markers = []
    tpw.Lights = []

'''


import dv3d_gui_Callbacks as cb
import time
import vtk

from dv3d_vtkTools_generateVTKSurface import *
from numpy import *


def writeImage(imageCounter, renderWindow):
    #write an image out to file
    windowToImageFilter = vtk.vtkWindowToImageFilter()
    windowToImageFilter.SetInput(renderWindow)
    windowToImageFilter.SetMagnification(1) #set the resolution of the output image (1x times the current resolution of vtk render window)
    windowToImageFilter.SetInputBufferTypeToRGBA() #also record the alpha (transparency) channel
    windowToImageFilter.Update()

    writer = vtk.vtkTIFFWriter()
    writer.SetCompressionToNoCompression()
    writer.SetFileName('/tmp/Rachel%05d.tiff' %imageCounter)
    writer.SetInputConnection(windowToImageFilter.GetOutputPort())
    writer.Write()


def runAutoScripts(the_parent_window):
    #pass # for now

    print 'executing auto script'

    tpw = the_parent_window

    camera = tpw.ren3d.GetActiveCamera()
    renWin = tpw.ren3d.GetRenderWindow()

    #Everything loaded, now lets start some interacting
    imageCounter = 0 #for naming output frames

    for i in range(90):
        camera.Azimuth(-1)
        tpw.iwidget_3d.interactor.GetRenderWindow().Render()
        writeImage(imageCounter, renWin)
        imageCounter += 1


    for i in range(60):
        camera.Azimuth(-1)
        tpw.Surfaces[1].GetProperty().SetOpacity(((100-i*2))/100.0)
        tpw.iwidget_3d.interactor.GetRenderWindow().Render()
        writeImage(imageCounter, renWin)
        imageCounter += 1
        
    for i in range(30):
        camera.Azimuth(-1)
        camera.Zoom(1.0125)
        tpw.iwidget_3d.interactor.GetRenderWindow().Render()
        writeImage(imageCounter, renWin)
        imageCounter += 1
        


