#!/usr/bin/python
#dv3d_io_autoScript.py
#Automatic processing of i/o for images / movies
#DV3D refactor 2
#AG 22/01/2013

''' 
Form the main script, type holders are:

    #the main data type holders
    tpw.Planes = []
    tpw.Volumes = []
    tpw.Surfaces = []
    tpw.SurfaceGroups = []
    tpw.Markers = []
    tpw.Lights = []

'''


import dv3d_gui_Callbacks as cb
import time
import vtk


def writeImage(imageCounter, renderWindow):
    #write an image out to file
    windowToImageFilter = vtk.vtkWindowToImageFilter()
    windowToImageFilter.SetInput(renderWindow)
    windowToImageFilter.SetMagnification(1) #set the resolution of the output image (1x times the current resolution of vtk render window)
    windowToImageFilter.SetInputBufferTypeToRGBA() #also record the alpha (transparency) channel
    windowToImageFilter.Update()

    writer = vtk.vtkTIFFWriter()
    writer.SetCompressionToNoCompression()
    writer.SetFileName('/tmp/frame%05d.tiff' %imageCounter)
    writer.SetInputConnection(windowToImageFilter.GetOutputPort())
    writer.Write()


def runAutoScripts(the_parent_window):
    #pass # for now
    print 'executing auto script'

    tpw = the_parent_window #for brevity

    # change background colour
    tpw.ren3d.SetBackground(1,1,1)

    # load base fmri Volume
    cb.cb_LoadDataForPlanes(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/MNI_structural.nii.gz")
    planes1 = tpw.Planes[-1]    

    # load cortex
    cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/Cortex_3mm.vtk")
    cortex = tpw.Surfaces[-1]
    #change appearance
    #cortex.GetProperty().SetRepresentationToWireframe()
    cortex.GetProperty().SetOpacity(1.0)
    cortex.GetProperty().SetColor(0.85,0.85,0.85)    

    # load thalamus
    cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/ThalamusFull.vtk")
    thalamus = tpw.Surfaces[-1]
    #change appearance
    #thalamus.GetProperty().SetRepresentationToWireframe()
    thalamus.GetProperty().SetOpacity(1)
    thalamus.GetProperty().SetColor(0,0.5,1)

    # load pulvinar
    cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/Pulvinar.vtk")
    pulvinar = tpw.Surfaces[-1]
    #change appearance
    ##pulvinar.GetProperty().SetRepresentationToWireframe()
    pulvinar.GetProperty().SetOpacity(0.0)
    pulvinar.GetProperty().SetColor(0,0,1)

    # load LGNs
    cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/LGNs.vtk")
    LGNs = tpw.Surfaces[-1]
    #change appearance
    ##LGNs.GetProperty().SetRepresentationToWireframe()
    LGNs.GetProperty().SetOpacity(0.0)
    LGNs.GetProperty().SetColor(1,0,0)

    # load i-pulvinar
    cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/iP.vtk")
    iPulvinar = tpw.Surfaces[-1]
    #change appearance
    ##iPulvinar.GetProperty().SetRepresentationToWireframe()
    iPulvinar.GetProperty().SetOpacity(0.0)
    iPulvinar.GetProperty().SetColor(1,0.5,0)

    # load DL-pulvinar
    cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/DLP.vtk")
    dlPulvinar = tpw.Surfaces[-1]
    #change appearance
    ##dlPulvinar.GetProperty().SetRepresentationToWireframe()
    dlPulvinar.GetProperty().SetOpacity(0.0)
    dlPulvinar.GetProperty().SetColor(0,1,0)


    # load MD-pulvinar
    cb.cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/MDP.vtk")
    mdPulvinar = tpw.Surfaces[-1]
    #change appearance
    ##mdPulvinar.GetProperty().SetRepresentationToWireframe()
    mdPulvinar.GetProperty().SetOpacity(0.0)
    mdPulvinar.GetProperty().SetColor(0.53,0.53,1)

    camera = tpw.ren3d.GetActiveCamera()
    renWin = tpw.ren3d.GetRenderWindow()

    #Everything loaded, now lets start some interacting
    imageCounter = 0 #for naming output frames

    #planes are off initially
    for thisPlaneGroup in tpw.Planes:
        thisPlaneGroup.planeWidget_3dX.Off()
        thisPlaneGroup.planeWidget_3dY.Off()
        thisPlaneGroup.planeWidget_3dZ.Off()

    #set up the correct camera position
    camera.SetFocalPoint(cortex.GetCenter())
    camera.Elevation(300)
    camera.Zoom(1.5)
    camera.SetViewUp(0,0,1)
    camera.Azimuth(-90)

    tpw.iwidget_3d.interactor.GetRenderWindow().Render()
    time.sleep(1.0)

    #first process is to rotate the cortex, fading it out
    #  to reveal the thalamus below
    for i in range(180):
        camera.Azimuth(2)
        cortex.GetProperty().SetOpacity((360-i*1.93)/360.0)
        tpw.iwidget_3d.interactor.GetRenderWindow().Render()
        #time.sleep(0.01)
        writeImage(imageCounter, renWin)
        imageCounter += 1


    for i in range(30):
        camera.Elevation(-2)
        camera.Zoom(1.015)
        tpw.iwidget_3d.interactor.GetRenderWindow().Render()       
        writeImage(imageCounter, renWin)
        imageCounter += 1


    for i in range(180):
        LGNs.GetProperty().SetOpacity(1.0)
        camera.Azimuth(1)
        tpw.iwidget_3d.interactor.GetRenderWindow().Render()
        writeImage(imageCounter, renWin)
        imageCounter += 1


'''
then run:
ffmpeg -r 25 -i /tmp/frame%05d.tiff -vb 10000k /tmp/video.mpg
'''


   

