#!/usr/bin/python
#dv3d_io_autoScript.py
#Automatic processing of i/o for images / movies
#DV3D refactor 2
#AG 22/01/2013

''' 
Form the main script, type holders are:

    #the main data type holders
    tpw.Planes = []
    tpw.Volumes = []
    tpw.Surfaces = []
    tpw.SurfaceGroups = []
    tpw.Markers = []
    tpw.Lights = []

'''


import dv3d_gui_Callbacks as cb
import time
import vtk

from dv3d_vtkTools_generateVTKSurface import *
from numpy import *


def writeImage(imageCounter, renderWindow):
    #write an image out to file
    windowToImageFilter = vtk.vtkWindowToImageFilter()
    windowToImageFilter.SetInput(renderWindow)
    windowToImageFilter.SetMagnification(1) #set the resolution of the output image (1x times the current resolution of vtk render window)
    windowToImageFilter.SetInputBufferTypeToRGBA() #also record the alpha (transparency) channel
    windowToImageFilter.Update()

    writer = vtk.vtkTIFFWriter()
    writer.SetCompressionToNoCompression()
    writer.SetFileName('/tmp/frame%05d.tiff' %imageCounter)
    writer.SetInputConnection(windowToImageFilter.GetOutputPort())
    writer.Write()


#08Jan2015 - script to load obj scalp file.

def runAutoScripts(the_parent_window):

	tpw = the_parent_window # for brevity
	
	#we want to add something to the main window
	
	# load it first
	myReader = vtk.vtkOBJReader()
	myReader.SetFileName('/groups/Projects/P1160/DV3D/Head_models/Jane_hi_neutral.obj')
	myReader.Update()
	
	
	#and export as vtk file
	outVTK = vtk.vtkPolyDataWriter()
	outVTK.SetInput(myReader.GetOutput())
	outVTK.SetFileName('/groups/Projects/P1160/DV3D/Head_models/Jane_hi_neutral.vtk')
	outVTK.SetFileTypeToASCII()
	outVTK.Write()
	
	print 'done'
