#!/usr/bin/python
#dv3d_io_autoScript.py
#Automatic processing of i/o for images / movies
#DV3D refactor 2
#AG 22/01/2013

''' 
Form the main script, type holders are:

    #the main data type holders
    tpw.Planes = []
    tpw.Volumes = []
    tpw.Surfaces = []
    tpw.SurfaceGroups = []
    tpw.Markers = []
    tpw.Lights = []

'''


import dv3d_gui_Callbacks as cb
import time
import vtk

from dv3d_vtkTools_generateVTKSurface import *
from numpy import *


def writeImage(imageCounter, renderWindow):
    #write an image out to file
    windowToImageFilter = vtk.vtkWindowToImageFilter()
    windowToImageFilter.SetInput(renderWindow)
    windowToImageFilter.SetMagnification(1) #set the resolution of the output image (1x times the current resolution of vtk render window)
    windowToImageFilter.SetInputBufferTypeToRGBA() #also record the alpha (transparency) channel
    windowToImageFilter.Update()

    writer = vtk.vtkTIFFWriter()
    writer.SetCompressionToNoCompression()
    writer.SetFileName('/tmp/frame%05d.tiff' %imageCounter)
    writer.SetInputConnection(windowToImageFilter.GetOutputPort())
    writer.Write()


#08Jan2015 - save out current displayed surface.

def runAutoScripts(the_parent_window):

	tpw = the_parent_window #for brevity

	#get the latest displayed surface from main window
	theSurface = tpw.Surfaces[-1]
	#print theSurface

	surfacePolyData = theSurface.GetMapper().GetInput()
	
	print surfacePolyData

#	#and export as vtk file
#	outVTK = vtk.vtkPolyDataWriter()
#	outVTK.SetInput(surfacePolyData)
#	outVTK.SetFileName('/groups/Projects/P1160/DV3D/Head_models/clip1.vtk')
#	outVTK.SetFileTypeToASCII()
#	outVTK.Write()

#	print 'clip1.vtk written'
	fill = vtk.vtkFillHolesFilter()
	fill.SetInput(surfacePolyData)
	fill.SetHoleSize(20000000000000.0)
	fill.Update()
	
	surfacePolyData = fill.GetOutput()
	surfacePolyData.Modified()


	#and export as vtk file
	outVTK = vtk.vtkPolyDataWriter()
	outVTK.SetInput(surfacePolyData)
	outVTK.SetFileName('/groups/Projects/P1160/DV3D/Head_models/fill1.vtk')
	outVTK.SetFileTypeToASCII()
	outVTK.Write()
	
	print 'wrote fill1.vtk'

