#!/usr/bin/python
#dv3d_io_autoScript.py
#Automatic processing of i/o for images / movies
#DV3D refactor 2
#AG 22/01/2013

''' 
Form the main script, type holders are:

    #the main data type holders
    tpw.Planes = []
    tpw.Volumes = []
    tpw.Surfaces = []
    tpw.SurfaceGroups = []
    tpw.Markers = []
    tpw.Lights = []

'''


import dv3d_gui_Callbacks as cb
import time
import vtk

from dv3d_vtkTools_generateVTKSurface import *
from numpy import *


def writeImage(imageCounter, renderWindow):
    #write an image out to file
    windowToImageFilter = vtk.vtkWindowToImageFilter()
    windowToImageFilter.SetInput(renderWindow)
    windowToImageFilter.SetMagnification(1) #set the resolution of the output image (1x times the current resolution of vtk render window)
    windowToImageFilter.SetInputBufferTypeToRGBA() #also record the alpha (transparency) channel
    windowToImageFilter.Update()

    writer = vtk.vtkTIFFWriter()
    writer.SetCompressionToNoCompression()
    writer.SetFileName('/tmp/frame%05d.tiff' %imageCounter)
    writer.SetInputConnection(windowToImageFilter.GetOutputPort())
    writer.Write()


def runAutoScripts(the_parent_window):
    #test code for extracting image plane coordinates
    print 'executing auto script'

    tpw = the_parent_window #for brevity

    # get the base planes   
    xp = tpw.Planes[0].planeWidget_3dX
    yp = tpw.Planes[0].planeWidget_3dY
    zp = tpw.Planes[0].planeWidget_3dZ

    print xp.GetOrigin(), xp.GetPoint1(), xp.GetPoint2()
    print yp.GetOrigin(), yp.GetPoint1(), yp.GetPoint2()
    print zp.GetOrigin(), zp.GetPoint1(), zp.GetPoint2()


    x1=(-223.19294566303785, 136.16043224757203, -0.9999999999998288)
    x2=(-12.593894804493393, 79.83956775242841, -0.9999999999998288)
    x3=(-223.19294566303785, 136.16043224757203, 181.0)
    y1=(-181.0, 148.112434156695, -1.0)
    y2=(-181.0, 148.112434156695, 181.0)
    y3=(1.0, 148.112434156695, -1.0)
    z1=(-176.7184311120662, -0.9999999999999425, 165.47622130798098)  
    z2=(-3.2815688879338145, -0.9999999999999425, 110.30689267469661)
    z3=(-176.7184311120662, 217.00000000000006, 165.47622130798098)

    xp.SetOrigin(x1)
    xp.SetPoint1(x2)
    xp.SetPoint2(x3)
    yp.SetOrigin(y1)
    yp.SetPoint1(y2)
    yp.SetPoint2(y3)
    zp.SetOrigin(z1)
    zp.SetPoint1(z2)
    zp.SetPoint2(z3)

    tpw.Planes[0].planeWidget_3dX.UpdatePlacement()
    tpw.Planes[0].planeWidget_3dY.UpdatePlacement()
    tpw.Planes[0].planeWidget_3dZ.UpdatePlacement()


    tpw.Planes[0].planeWidget_3dX.Modified()
    tpw.Planes[0].planeWidget_3dY.Modified()
    tpw.Planes[0].planeWidget_3dZ.Modified()

    tpw.ren.Render()






