#!/usr/bin/python
#dv3d_io_autoScript.py
#Automatic processing of i/o for images / movies
#DV3D refactor 2
#AG 22/01/2013

''' 
Form the main script, type holders are:

    #the main data type holders
    tpw.Planes = []
    tpw.Volumes = []
    tpw.Surfaces = []
    tpw.SurfaceGroups = []
    tpw.Markers = []
    tpw.Lights = []

'''


from dv3d_gui_Callbacks import *


def runAutoScripts(the_parent_window):
    #pass # for now
    print 'executing auto script'

    tpw = the_parent_window #for brevity

    # change background colour
    tpw.ren3d.SetBackground(1,1,1)

    # load base fmri Volume
    cb_LoadDataForPlanes(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/MNI_structural.nii.gz")

    # load cortex
    cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/Cortex_3mm.vtk")
    #change appearance
    tpw.Surfaces[-1].GetProperty().SetRepresentationToWireframe()
    tpw.Surfaces[-1].GetProperty().SetOpacity(0.025)
    tpw.Surfaces[-1].GetProperty().SetColor(0.95,0.95,0.95)    

    # load thalamus
    cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/ThalamusFull.vtk")
    #change appearance
    tpw.Surfaces[-1].GetProperty().SetRepresentationToWireframe()
    tpw.Surfaces[-1].GetProperty().SetOpacity(0.05)
    tpw.Surfaces[-1].GetProperty().SetColor(0,0,1)

    # load pulvinar
    cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/Pulvinar.vtk")
    #change appearance
    ##tpw.Surfaces[-1].GetProperty().SetRepresentationToWireframe()
    tpw.Surfaces[-1].GetProperty().SetOpacity(0.05)
    tpw.Surfaces[-1].GetProperty().SetColor(0,0,1)

    # load LGNs
    cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/LGNs.vtk")
    #change appearance
    ##tpw.Surfaces[-1].GetProperty().SetRepresentationToWireframe()
    ##tpw.Surfaces[-1].GetProperty().SetOpacity(0.05)
    tpw.Surfaces[-1].GetProperty().SetColor(1,0,0)

    # load i-pulvinar
    cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/iP.vtk")
    #change appearance
    ##tpw.Surfaces[-1].GetProperty().SetRepresentationToWireframe()
    ##tpw.Surfaces[-1].GetProperty().SetOpacity(0.05)
    tpw.Surfaces[-1].GetProperty().SetColor(1,0.5,0)

    # load DL-pulvinar
    cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/DLP.vtk")
    #change appearance
    ##tpw.Surfaces[-1].GetProperty().SetRepresentationToWireframe()
    ##tpw.Surfaces[-1].GetProperty().SetOpacity(0.05)
    tpw.Surfaces[-1].GetProperty().SetColor(0,1,0)


    # load MD-pulvinar
    cb_LoadDataForSurface(tpw, "/scratch/home/andre/4_code/kinect2/code/pyosceleton/anatomy/MDP.vtk")
    #change appearance
    ##tpw.Surfaces[-1].GetProperty().SetRepresentationToWireframe()
    ##tpw.Surfaces[-1].GetProperty().SetOpacity(0.05)
    tpw.Surfaces[-1].GetProperty().SetColor(0.53,0.53,1)









   

