#!/usr/bin/python
#dv3d_io_autoScript.py
#Automatic processing of i/o for images / movies
#DV3D refactor 2
#AG 22/01/2013

''' 
Form the main script, type holders are:

    #the main data type holders
    tpw.Planes = []
    tpw.Volumes = []
    tpw.Surfaces = []
    tpw.SurfaceGroups = []
    tpw.Markers = []
    tpw.Lights = []

'''


import dv3d_gui_Callbacks as cb
import time
import vtk

from dv3d_vtkTools_generateVTKSurface import *
from numpy import *


def writeImage(imageCounter, renderWindow):
    #write an image out to file
    windowToImageFilter = vtk.vtkWindowToImageFilter()
    windowToImageFilter.SetInput(renderWindow)
    windowToImageFilter.SetMagnification(1) #set the resolution of the output image (1x times the current resolution of vtk render window)
    windowToImageFilter.SetInputBufferTypeToRGBA() #also record the alpha (transparency) channel
    windowToImageFilter.Update()

    writer = vtk.vtkTIFFWriter()
    writer.SetCompressionToNoCompression()
    writer.SetFileName('/tmp/frame%05d.tiff' %imageCounter)
    writer.SetInputConnection(windowToImageFilter.GetOutputPort())
    writer.Write()


#08Jan2015 - save out current displayed surface.

def runAutoScripts(the_parent_window):

	tpw = the_parent_window #for brevity
	
	#surface to work with is already loaded
	mySurface = tpw.Surfaces[-1]
	
	camera = tpw.ren3d.GetActiveCamera()
    renWin = tpw.ren3d.GetRenderWindow()
    
    #set up the correct camera position
    camera.SetFocalPoint(mySurface.GetCenter()) #look at the center of the surface
    camera.Elevation(300)
    camera.Zoom(1.5)
    camera.SetViewUp(0,0,1)
    camera.Azimuth(-90)

#    tpw.iwidget_3d.interactor.GetRenderWindow().Render()
#    time.sleep(1.0)
#
#    
#    camera.Azimuth(180)
#
#    for i in range(30):
#        writeImage(imageCounter, renWin)
#        imageCounter += 1
    
    
    
    
    
