#!/usr/bin/python
#DV3D.py
#Main dv3d application launcher
#DV3D refactor 2
#AG 26/07/2013

#core libs
import vtk
import os,sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *

#gui setup 
import ui_v9
from dv3d_gui_BuildList import *
from dv3d_gui_SetupMainFrames import *
from dv3d_gui_FileDialogs import *
from dv3d_gui_Callbacks import *
from dv3dVTKFrameGui import QVtkInteractorWidget
from dv3d_gui_SetupMainWindowFields import *

#data handling
from dv3d_data_LoadNiftiVolume_Planes import *
from dv3d_data_LoadVtkSurface import *
from dv3d_data_AddLights import *
from dv3d_data_SetupDataTypes import *
from dv3dNiftiHandler import *

#other functions
from dv3d_data_Sync3Dand2DPlanes import SyncPlanes


#set up the main window
class dv3dLaunch(QMainWindow, ui_v9.Ui_myMainWindow):  

    def __init__(self, text, parent=None):
        super(dv3dLaunch, self).__init__(parent)
        self.__text = unicode(text)
        self.__index = 0
        self.setupUi(self)


        # lay out the main vtk window views (3d and 2d)
        dv3d_gui_SetupMainFrames(self)

        # create some holders for data that we load
        dv3d_data_SetupDataTypes(self)

        # populate the tree list (items)     
        dv3d_gui_BuildList(self.ItemList_QTreeWidget)

        #setup other general gui features 
        dv3d_gui_SetupMainWindowFields(self)

        # Set up callbacks (the stuff that buttons do when you click them)
        dv3d_gui_Callbacks(self)


        # Add some lighting to the main window
        #dv3d_data_AddLights(self)

        #let's keep track of which dataTypes we have loaded thus far
        self.PlaneLoaded = 0
        self.SurfaceLoaded = 0
        self.MarkerLoaded = 0
        self.VolumeLoaded = 0

        #let's keep track of whether we are performing an update that may
        # produce erratic (but expected) calls to the gui callabcks 
        self.currentlyLoading = 0

        #lets keep track of when we first load something
        self.anythingLoaded = False


        ##------------------------------------------------ 
        ## On startup, offer to load some data
        #thisFile = dv3dFileOpen(self, "Nifti GZ (*.nii.gz)\nVTK surface (*.vtk)") #Nifti (*.nii *.img)\n
        #if thisFile != None:
        #    if '.nii.gz' in thisFile:
        #        self.currentlyLoading = 1
        #        dv3d_data_LoadNiftiVolume_Planes(self, thisFile)
        #        self.currentlyLoading = 0
        #    elif '.vtk' in thisFile:
        #        self.currentlyLoading = 1
        #        dv3d_data_LoadVtkSurface(self, thisFile)
        #        self.currentlyLoading = 0
        #    else:
        #        pass #for now

        ###test launch a property dialog
        ##t = planePropertyPanel(self)


    # we may be loading multiple planes and we need them all to do the same thing
    def runSyncPlanes(self, arg1=1, arg2=2):
        SyncPlanes(self, self.X_plane_list, self.Y_plane_list, self.Z_plane_list)
        self.ren1.ResetCamera()
        self.ren2.ResetCamera()
        self.ren3.ResetCamera()


        
if __name__ == "__main__":
    import sys
    text = "DV3D"
    app = QApplication(sys.argv)
    dv3dMain = dv3dLaunch(text)
    dv3dMain.show()

    dv3dMain.iwidget_3d.interactor.GetRenderWindow().Render()
    dv3dMain.ren1.ResetCamera()
    dv3dMain.ren2.ResetCamera()
    dv3dMain.ren3.ResetCamera()

    dv3dMain.iwidget_2dX.interactor.GetRenderWindow().Render()
    dv3dMain.iwidget_2dY.interactor.GetRenderWindow().Render()
    dv3dMain.iwidget_2dZ.interactor.GetRenderWindow().Render()


    app.exec_()
