function rx = ynicRxManualMatrix(rx);

if ieNotDefined('rx')
    cfig = findobj('Tag','rxControlFig');
    rx = get(cfig,'UserData');
end

options.Resize = 'on';

resp = inputdlg({'Enter the 4x4 transformation matrix', ...
                 'Transform around centre (0=edge, 1=centre)'}, ...
                'Manually Enter Transformation Matrix', ...
                4, ...
                {'', '', '', ''}, ...
                options);

tmp = str2num(resp{1});
aroundcentre = str2num(resp{2});

if ~isequal(size(tmp), [4, 4])
    myErrorDlg('Transform is not 4x4');
    return;
end

rx = rxSetXform(rx, tmp, aroundcentre);
rx = rxStore(rx, 'Manual Matrix');

return

