%% Load diffusion weighted imaging data

dataDir = fullfile(mrvDataRootPath,'diffusion','sampleData');
dwi = dwiLoad(fullfile(dataDir,'raw','dwi.nii.gz'));
bvecs = dwiGet(dwi,'diffusion bvecs');


%% Make a sphere
mrvNewGraphWin;
[X,Y,Z] = sphere(15);
[r,c] = size(X);

surf(X,Y,Z);
colormap(jet); set(gca,'Projection','Ortho'); axis equal
set(gca,'xtick',[-1 0 1],'ytick',[-1 0 1],'ztick',[-1 0 1])
grid off; axis off

%% 
s = 1.07;
hold on; plot3(s*bvecs(:,1),s*bvecs(:,2),s*bvecs(:,3),'ko','markerfacecolor','w','markersize',10)

%% Turn off the bottom half of the sphere
mrvNewGraphWin;
l = (Z < 0); X(l) = NaN; Y(l) = NaN; Z(l) = NaN;
surf(X,Y,Z);
colormap(jet); set(gca,'Projection','Ortho'); axis equal
set(gca,'xtick',[-1 0 1],'ytick',[-1 0 1],'ztick',[-1 0 1])
grid off; axis off

l = (bvecs(:,3) > 0);
hold on; plot3(s*bvecs(l,1),s*bvecs(l,2),s*bvecs(l,3),'ko','markerfacecolor','w','markersize',10)


%%
% The vistadata diffusion sample data are 40-directions.  The directory
% contains the dwi data as well as the bvals and bvecs.

cCoords = [47 54 43];  % Circular
dCoords = [44 54 43];  % Directional



