function cFiles = defaultCFileList;
% Returns a list of all .c source files found in the VISTASOFT repository.
%
% cFiles = defaultCFileList;
%
% This list was found using grep (around October 2008). cFiles is a cell
% array of strings. Each entry is relative to the default VISTASOFT root
% path.
%
% Some mex files need to concatenate multiple source files. You can
% concatenate the source file names separated by a ';'. E.g.:
% '/some/dir/first.c;some/dir/second.c' will compile first.c as the mex
% file 'first.mexext' and link in the code from second.c.
%
% ras 10/2008.
% 2009.07.01 RFD: cleaned up a few details. Can now compile things that
% require multiple source files (e.g., readFileNifti)

cFiles = {...
    'fileFilters/nifti/matToQuat.c;fileFilters/nifti/nifti1_io.c;fileFilters/nifti/znzlib.c' ...
	'fileFilters/nifti/readFileNifti.c;fileFilters/nifti/nifti1_io.c;fileFilters/nifti/znzlib.c' ...
	'fileFilters/nifti/writeFileNifti.c;fileFilters/nifti/nifti1_io.c;fileFilters/nifti/znzlib.c' ...
	'mrFlatMesh/CSource/mrManDist.c' ...
	'mrFlatMesh/CSource/assignToNearest.c' ...
	'mrLoadRet/Analysis/MotionComp/MI/MI/Joint_Histogram/spm_hist2_weighted.c' ...
	'mrLoadRet/Analysis/MotionComp/MI/MI/Joint_Histogram/spm_hist2_weighted_MI.c' ...
	'mrLoadRet/Analysis/Copreview/coranal.c' ...
	'mrLoadRet/Analysis/SignalProc/sumOfNeighbors.c' ...
	'mrLoadRet/Analysis/Atlas/updateTinC.c' ...
	'mrLoadRet/Analysis/retinotopyModel/Misc/varOfNeighbors.c' ...
	'mrDiffusion/src/dtiFitTensor.c' ...
	'mrDiffusion/src/dtiJointHist.c' ...
	'mrDiffusion/src/dtiSplitTensor.c' ...
	'mrDiffusion/src/dtiTensorInterp_Pajevic.c' ...
	'mrDiffusion/src/ndfun.c' ...
	'mrDiffusion/src/magicwand1.c' ...
	'mrDiffusion/xform/fastDeformation/initInvDiagsInC.c' ...
	'mrDiffusion/xform/fastDeformation/trilin.c' ...
	'mrDiffusion/file/dtiLoadConTrackPaths.c' ...
	'mrAnatomy/VolumeUtilities/mrAnatFastInterp3.c' ...
	'mrAnatomy/VolumeUtilities/myCinterp3.c' ...
	'mrAnatomy/mrMesh/findNearest.c' ...
	'mrAnatomy/mrMesh/tcpToolbox/pnet.c' ...
	'mrAnatomy/ManifoldUtilities/Csource/mrManDist.c' ...
	'mrAnatomy/ManifoldUtilities/Csource/assignToNearest.c' ...
	'mrAnatomy/ManifoldUtilities/Csource/edgesCross2d.c' ...
	'mrAnatomy/ManifoldUtilities/Csource/mCheck.c' ...
	'mrAnatomy/ManifoldUtilities/Csource/mrCheckNode2dIntersect.c' ...
	'mrVista2/mrMethods/svm/cawleyTools/@rbf/evaluate.c' ...
    'mrAlign/regHistogram.c' ...
	'mrAlign/C-code/mexglx/SagittalRot.c' ...
	'mrAlign/C-code/mexglx/ObliqueRot.c' ...
	'mrAlign/C-code/SagittalRot.c' ...
	'mrAlign/C-code/ObliqueRot.c' ...
	'mrAlign/C-code/Version4/SagittalRot.c' ...
	'mrAlign/regInplanes.c' ...
    'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/corrDn.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/histo.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/mexglx/corrDn.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/mexglx/histo.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/mexglx/wrap.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/mexglx/convolve.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/mexglx/upConv.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/mexglx/range2.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/mexglx/edges-orig.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/mexglx/edges.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/mexglx/pointOp.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/wrap.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/convolve.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/upConv.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/range2.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/edges-orig.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/edges.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/MEX/pointOp.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/PCMex/corrDn.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/PCMex/histo.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/PCMex/wrap.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/PCMex/convolve.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/PCMex/upConv.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/PCMex/range2.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/PCMex/edges-orig.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/PCMex/edges.c' ...
	'mrLoadRet/Utilities/helperFunctions/pyrTools/PCMex/pointOp.c' ...
	'mrLoadRet/Analysis/retinotopyModel_old/Misc/varOfNeighbors.c' ...
	};

return