%
%    [id, status, result] = mrMesh(Server_ip, ID, Command, Parameters)
%
% Author: In-Solve, Dima Mihaylov's team
% Purpose:
%
% This is the MEX function to call the 3D visualization too, mrMesh.
% Use this function to issue a command to a mrMesh server.
%
% Each client can create number of visualization windows on
% the server and issue commands to these windows using task creation time
% returned ID. For example, client can call to apply some ROI to some task
% (window).
% 
% Input arguments:
% Server_ip:  server's IP address. This is usually localhost when
% connecting to a server on the same computer.
% 
% ID:  service ID to communicate with. Use it to identify task to issue
% command on. If no service ID yet known (for example, the command is to
% create a new task), it can be -1.
% 
% Command:  Text description of command. A list of available commands can
% be found later in this document and at the web-site (???)
% 
% Parameters: A structure containing the command parameters. The required
% parameters in the structure should contain any named variables of
% following types: double real scalars  (1x1), double real matrixes of
% number of dimensions up to 10, strings. All parameters are sent to server
% and interpreted by it according to specified command.
%    For example, p.color = [.3,.3,.3,1]; 
%       or p.get_all = 1;
% 
% You can skip parameters (give no such argument) if parameters are not
% needed. Server will receive empty parameters set.
%
% Return arguments:
% 
% ID: Service ID of a task created or given by client. For tasks in
% progress it equals to ID given in parameters. You should store this value
% if your command is to create a new task to reference created task later.
% 
% Status:  A quick status of a command execution. Positive values (>0) are
% successful, negative (<0) are unsuccessful, zero means client/server
% communication error (network error), generated by client itself.
% 
% On server-side failure (Status<0) Result. Error string usually contains
% server given error description.
% 
% Result: A cell array of number of named variables of following types:
% string, double real scalar (1x1), double real matrixes of arbitrary
% number of dimensions (up to 10). Server can return data here. You can
% examine this cell array if some data expected as a result of command
% processing.
%
% SCENE ACTORS
% 
% Actor is a base scene object which can be moved, modified, and set up by
% accessing properties. You should create actors of different types to
% populate your 3D scene. Each actor has specific ID returned by add_actor
% command.
%
% SPECIAL ACTORS
% 
%   The scene includes many entities, such as the background and the camera.
%   The scene can include various objects (meshes) that can be separately
%   addressed.  These are called actors.  If you want to change the color
%   of one actor, but not another, you must know its actorID.
%   
% First 32 actor id's are reserved for special actors. Currently, two of
% them are used: 0 is the camera and 1 is 3d-cursor. These id's can be used
% e.g. to retrieve or change camera or cursor position.
%
% ACTOR TYPES AND PROPERTIES
% Common properties
% 
% "origin" (float[3]) - actor position in world coordinates.
% 
% "rotation" (float[3x3]) - rotation matrix.
% 
% "camera_space" (bool) - If set to 0 (default), object coordinates are
% defined in world coordinate system and transformed by camera matrix; If
% set to 1, object position is relative to camera.
%
% polyline
% "points[3xN]" (float) - point coordinates.
% "color[4]" (byte) - line color.
% "width" (float) - line width in pixels.
%    Question: Should we use polyline for the dti fibers?
%
% image
% "width", "height" (float) - rectangle sizes.
% "texture_file" (string) - image file name to load (for "set" only).
% "texture[3xN]" or "texture[4xN]" (float in range [0,1) ) - bitmap to set
% as texture (requires "tex_width"(int) and "tex_height"(int); for "set"
% command only). 
%
% text
% "text" (string) - string to display.
% "color" (float[3] or float[4]) - text color.
%   Question:  How do we set the position of the text display? 
%
% camera
% "frustum[4]" (float) - projection settings:
% {view frustum width; view frustum height; near clip plane; far clip plane}.
%
% light
% "diffuse" (float[3]) - Light color. Note, that unlike all other actors,
% these value must be in range [0:1). (default: 1, 1, 1).
% "ambient" (float[3]) - Ambient color. Note, that unlike all other actors,
% these value must be in range [0:1). (default: 0, 0, 0).
% "cutoff" (float) - half-cone angle: 0-90 for focused light source, 180 -
% for omni directed (default: 180).
%     Question:  How do we set the direction of the half-cone angle for
%     focused light sources?
%
% mesh
% "vertices" (float[3xN]),
% "normals" (float[3xN]),
% "colors" (float[4xN]),
% "triangles" (int [3xN]) -
%   Mesh data returned by "get" command and used in "set_mesh" and "modify_mesh".
%
%   Once you have built a mesh properly, you can create another view of it
%   using the set_mesh command.  The data contained inside mesh.data are
%   all that you need to invoke a set_mesh command and have the actor
%   appear.
%
%   We might have mesh.scene (global scene properties) and mesh.actor (for
%   specific objects in the scene).  We should have actor be a struct array
%   whose entries are the same as what you get from get_mesh command.
%
% mrMesh client command reference
%   If service ID is -1, new render window is created (if command have some
%   meaning in that mode). For example you can build mesh into existing or
%   new window by setting ID to valid window ID or to -1.
%
%
% GENERAL COMMANDS
%
% enable_lighting
%  Sets up lighting properties.
%  Parameters: "enable" (bool) - turn on/off lighting (default: 1)
%
% refresh
%  Force frame update (may be needed after camera position was changed).
%  Parameters: None
%
% transparency
%  Turn transparency on/off. Transparency can be turned off to speed up
%  drawing of a scene without transparent parts.
%  Parameters: "enable" (bool) - enable or disable transparency.
% 
% set_size
%  Resizes the client window. This is especially useful for making movies,
%  where you might want screenshots to have a particular aspect ratio.
%  Unfortunately, it doesn't quite do the right thing (the client area is
%  resized, but the window frame is not). It might still be useful to get
%  and exact frame size. You will just have to manually adjust the window 
%  frame size after using this command.
%  Parameters: width, height (in pixels).
%  
%
% screenshot
%  Parameters:
%   filename (string) - image file name. Snapshot are saved in .bmp
%    format. If no "filename" specified, mrMesh will generate a sequential
%    name ("shotNNNN.bmp"). If filename is set to 'nosave', then no file is
%    saved.
%  Returns:
%   rgb: an NxMx3 RGB image containing the screen shot.
%  
%
% SCENE COMMANDS
%
% add_actor
%  Parameters: "class"(string) - actor class.
%  Returns: "actor"(int) - actor id.
%
% remove_actor
%  Parameters: "actor"(int) - actor class.
%
% background
%  Change the scene background color.
%  Parameters: color - an RGBA color array (eg. [.3,.3,.3,1]).
%  p.color = [.3,.3,.3,1];
%  mrMesh(host,id,'background',p);
%
% ACTOR COMMANDS
%
% set
%   Parameters: <property> = <value>.
%   p.actor = actorID; p.PROPERTY = val ; [tmp,foo,res] = mrMesh(host,windowID,'set',p);
%   [id, stat, res] = mrMesh(host, windowID, 'set_mesh', p);
%   [tmp,foo,val] = mrMesh(host,windowID,'set_size',p);
%   [id,stat,res] = mrMesh(host,windowID, 'set_selection', p);  % (Cursor properties)
%   mrmSet(msh,'set_window_title','title goes here');
%
% get
%   Parameters:
%   To specify actor properties to retrieve set this field:
%   "get_<property>" = 1 for each required field
%   Returns: "<property>"
%
%
% MESH MANIPULATION COMMANDS
% 
%   * All of these commands require you to specify 'actor' field that is a
%   value returned after 'add_actor class = mesh' command.
%   * All color values are 4-component (r,g,b,a).
% 
% open_gray
%   This command opens specified .Gray file in render window.
%   Parameters:
%   filename: name of file to load into view.
%
%   do_decimate (bool):  set to 1 if decimation is needed (default: 1)
%   decimate_reduction (float) target reduction (default is 0.9 to
%    leave 10% of triangles)
%   decimate_iterations (int) number of iterations (default: 6)
%   decimate_subiterations (int) number of subiterations (default: 2)
%   decimate_preserve_edges (int) save mesh edges (default: 0)
%   decimate_preserve_topology (int) preserve topology (default: 1)
%   decimate_boudary_vertex_deletion (bool) to allow deletion of
%    vertices on the boundary of a mesh (default: 1)
%   decimate_aspect_ratio (float) - maximum allowable aspect ratio during
%    triangulation (default: 25)
%   decimate_degree (int) - Number of triangles connected to a vertex
%    exceeds "Degree", when the vertex is considered complex and is never
%    deleted. The complexity of the triangulation algorithm is proportional
%    to Degree^2 (default: 20).
%
%   do_smooth_pre (bool) - flag to do pre-decimation smoothing. The
%    do_smooth flag (below) specifies POST-DECIMATION smoothing! With
%    do_smooth_pre, you can specify pre-decimation smoothing. Note that the
%    parameters used are the same as those for do_smooth. Thus, if you want
%    pre-decimation smoothing to use different parameters, you will need to
%    set do_smooth to 0 and then apply the post-decimation smoothing after
%    the mesh is built (using the smooth_mesh command). 
%   do_smooth (bool) set to 1 to smooth mesh surface (default: 1)
%   smooth_sinc_method (bool) - flag to use windowed-sinc smoothing rather
%    than the standard vtkSmooth algorithm (which uses Laplacian smoothing).
%    According to the VTK help, the sinc method does a better job of
%    minimizing mesh shrinkage. Note that if you use sinc, smooth_relaxation
%    is the passband parameter. Lower values will give more smoothing
%    (opposite of the standard smoothing algorithm!). Try .05 with 20-40
%    iterations for light smoothing, or .0001 with 150 iterations to fully
%    relax a mesh. 
%   smooth_iterations (int) maximum number of iterations (default: 20)
%   smooth_relaxation (float) relaxation factor (default: 0.1)
%   smooth_feature_angle (float) - feature angle for sharp edge
%    identification (default: 45)
%   smooth_edge_angle (float) - angle to control smoothing along edges
%    (default: 15)
%   smooth_boundary (bool) enable smoothing of vertices on the boundary
%    of the mesh (default: 1)
%   smooth_feature_angle_smoothing (bool) enable smoothing along sharp
%    interior edges (default: 0)
% 
% open_class
%  Opens specified .class file into render window.
%  Parameters: Any parameters described for open_gray".
%
% open_mrm
%  Opens specified .mrm file into render window.
%  Parameters: filename -- name of file to load into view.
% 
% build_mesh
%  Builds mesh based on voxels given.
%  Parameters:
%  voxels (3D array) voxel bitmap. 
%          0 indicates point outside volume, 
%          1 point inside volume.
%  scale[3] (float) - voxel size (something around 1,1,1).
%  Plus any parameters described for "open_gray".
% 
% get_mesh
%  Returns current mesh 3D data.
%  Parameters:
%  get_vertices, get_normals, get_colors, get_polys, get_bounds
%  (bool, all "true" by default) - specify fields to retrieve.
%  Returns:
%  vertices[3,NVertices]  (float) - array of vertex coordinates (x,y,z).
%  normals[3,NVertices] (float) - array of vertex normals (x,y,z).
%  colors[4,NVertices] (int) - array of vertex colors (r,g,b,a).
%  strips_count (int) - number of triangles strips.
%  strips[1,Nx] (int) - array of triangle strips (The strip format is:
%    (m,i1,i2,i3,i4,...im  , n,i1,i2,..., in,...) where m and n are the
%    number of vertices in a strip and the i's are indexes in 'vertices').
%  triangles[3,NTriangles] (int) - indexes of vertices in standalone
%    triangles.
% 
% Example:
%  This command sequence builds bagel given by 4 enabled voxels in a cross
%  with center voxel disabled, and then captures  the mesh back.
%  p.voxels(1,2,1) = 1;
%  p.voxels(1,3,2) = 1;
%  p.voxels(1,2,3) = 1;
%  p.voxels(1,1,2) = 1;
%  [id, status, result] = mrMesh ('localhost', -1, 'build_mesh', p)
%  [id, status, result] = mrMesh ('localhost', id, 'get_mesh')
%
% set_mesh
%  Setup mesh using given 3D data. Data format is compatible with
%  'get_mesh' output. If no normals given, mesh normals are calculated
%  internally.
%  Parameters:
%   vertices[3,NVertices] (float) - array of vertex coordinates (x,y,z).
%   normals[3,NVertices] (float) - array of vertex normals (x,y,z).
%   colors[4,NVertices] (int) - array of vertex colors (r,g,b,a).
%   strips[1,Nx] (int) - array of triangle strips (see get_mesh for format).
%   triangles"[3, NTriangles] - array of triangles.
% 
% modify_mesh
%  Sets vertex coordinates, normals or colors for current mesh.
%  Parameters:
%   vertices[3,NVertices] (float) - array of vertex coordinates (x,y,z).
%   normals[3,NVertices] (float) - array of vertex normals (x,y,z).
%   colors[4,NVertices] (int) - array of vertex colors (r,g,b,a).
% 
% smooth_mesh
%  Smooth existing mesh.
%  Parameters:
%  Subset of parameters for 'open_gray', all related to smoothing.
%
% decimate_mesh
%  Decimate existing mesh.
%  Parameters: 
%  Subset of parameters for 'open_gray', all related to decimation.
% 
% apply_roi
%  This command should be used to apply ROI to mesh in given render window.
%  Parameters:
%   filename name of file to apply to mesh.
%   mix_factor (float) - assume given ROI to have this alpha (opacity).
%    (default: 1.0f).
%   alpha (float) - alpha to set for points in ROI (default: leave mesh
%    alpha as is).
% 
% reset_color
%  (documentation is pending)
%
% paint [NOT WORKING???]
%  Colors points on mesh surface.
%  Parameters:
%   coords[3xN] - points coordinates.
%   colors[4xN or 4x1] - array of colors (r,g,b,a values = 0..255). If only
%    one color value given, all points will be set to the same color.
%    Otherwise this array should contain colors for every point specified in
%    'coords'.
%   mix_factor (float or float[N]) - assume new points to have this alpha.
% 
% curvatures
%  Parameters:
%   modulate_color (bool) - colour mesh surface according to its curvature
%    (default: 1).
%   mod_depth (float) - color alteration strength (default: 0.5).
%   get_values (bool) - if 1, this function returns array of curvature
%    values (default: 0).
%  Returns:
%   values[NVertices] - if "get_values" set to 1, contains curvature values
%    for each vertex (1 for most convex point, -1 for most concave).
%
% tube
%  Creates tube by given points. A whole set of tubes can be built with a
%  single tube command- just put a [999,999,999] in the points list
%  whenever you want to start a new tube. All tubes built this way form a
%  single mesh (ie. all are one actor). This makes building large bundles
%  of tubes about 1000 times faster.
%  Parameters:
%   points (float[3xN]) - tube axis line points.
%   radius (float) - tube radius (default: 1.0).
%   sides (int) - number of sides (default: 6).
%   cap (bool) - set to create closed mesh (default: 1).
%   color (float[4]) - tube color (def: {192,192,192,255}).
%
%
% OTHER COMMANDS
%
% close
%  Closes given visualization window.
%  Parameters: None
%
% help
%  Returns list of commands.
%  Parameters: None
%  Returns: Available commands (string) commands list.
%
% HISTORY:
%  The mrMesh project was conceived by Bob Dougherty (RFD), Brian Wandell
%  (BAW) and Alex Wade (ARW). The C++ project (mrMeshSrv and mrMesh mex
%  client) was implemented under contract by Dima Mihaylov's team at
%  In-Solve in Russia. They vanished and we now have the source and build
%  it at Stanford. RFD developed the server side after the Russians
%  vanished.
%
%  The mrmSet, mrmGet, mrMesh matlab code was originally implemented by
%  David Ress (DR), ARW, RFD, BAW.
% 
% 2003.12.19 RFD: wrote this help file, based on the mrMesh user guide
% originally written by In-Solve.
