function ipROI = vol2ipRoiHB(volROI,vANATOMYPATH, mrSESSION)
% 
% ipROI = vol2ipROI(volROI)
%
% Creates a inplane ROI from an volume ROI by mapping
% coordinates, keeping track of partial voluming
%    
% ipROI and volROI are ROI structures, like those found in 
% view.ROIs 
%
% djh, 8/98.
% hab, 2009.03.17 - Modified, excluding "view" structure inputs so that it
% can be run outside mrVista

%inplane = initHiddenInplane;

% Get voxel sizes to make sure that the transformation preserves volume
ipVoxSize = mrSESSION.inplanes.voxelSize;
volVoxSize = readVolAnatHeader(vANATOMYPATH);

% Transform ROI coordinates
xform = inv(mrSESSION.alignment);

coords = xformROIcoords(volROI.coords,xform,volVoxSize,ipVoxSize);

% Toss coords outside the inplanes
ipSize = [mrSESSION.inplanes.cropSize, mrSESSION.inplanes.nSlices];
indices = ((coords(1,:) >= 1) & (coords(1,:) <= ipSize(1)) & ...
    (coords(2,:) >= 1) & (coords(2,:) <= ipSize(2)) & ...
    (coords(3,:) >= 1) & (coords(3,:) <= ipSize(3)));
coords = coords(:,indices);

% Set the fields 
ipROI.coords = coords;
ipROI.color = volROI.color;
ipROI.name = volROI.name;
ipROI.viewType = 'Inplane';
ipROI = sortFields(ipROI); % just to be safe

%[inplane,pos] = addROI(inplane,ipROI,2);

return;

%%%%%%%%%%%%%%
% Debug/test %
%%%%%%%%%%%%%%

volROI = VOLUME{1}.ROIs(VOLUME{1}.selectedROI);
ipROI = vol2ipROI(volROI,VOLUME{1},INPLANE{1});
newvolROI = ip2volROI(ipROI,INPLANE{1},VOLUME{1});
volROI.coords
newvolROI.coords
