function volROI = ip2volRoiHB(ipROI)
% 
% volROI = ip2volROI(ipROI,ipView,volView)
%
% Creates a volume ROI from an inplane ROI by mapping
% coordinates, keeping track of partial voluming
%    
% ipROI and volROI are ROI structures, like those found in 
% view.ROIs 
%
% djh, 8/98.
% hab, 2009.06.09 - Modified, excluding "view" structure inputs so that it
% can be run outside mrVista

global mrSESSION
global vANATOMYPATH

%volume = initHiddenVolume;

% Get voxel sizes to make sure that the transformation preserves volume
ipVoxSize = mrSESSION.inplanes.voxelSize;
volVoxSize = readVolAnatHeader(vANATOMYPATH);

% Transform ROI coordinates
xform = mrSESSION.alignment;

coords = xformROIcoords(ipROI.coords,xform,ipVoxSize,volVoxSize);

% Toss coords outside the volume
[mmPerPix, volSize] = readVolAnatHeader(vANATOMYPATH);
indices = ((coords(1,:) >= 1) & (coords(1,:) <= volSize(1)) & ...
    (coords(2,:) >= 1) & (coords(2,:) <= volSize(2)) & ...
    (coords(3,:) >= 1) & (coords(3,:) <= volSize(3)));
coords = coords(:,indices);

% Set the other fields and sort
volROI.coords = coords;
volROI.name = ipROI.name;
volROI.color = ipROI.color;
volROI.viewType = 'Volume';
volROI = sortFields(volROI); % just to be safe

return;

%%%%%%%%%%%%%%
% Debug/test %
%%%%%%%%%%%%%%

ipROI = INPLANE{1}.ROIs(INPLANE{1}.selectedROI);
volROI = ip2volROI(ipROI,INPLANE{1},VOLUME{1});
newipROI = vol2ipROI(volROI,VOLUME{1},INPLANE{1});
ipROI.coords
newipROI.coords
