function vw = makeTSeriesMovie(vw,scan,slice,anatFlag,thresh)
% 
% vw = makeTSeriesMovie(vw,[scan],[slice],[anatFlag],[thresh])
%
% Makes movie of tSeries for current scan and slice and sets the field
% vw.ui.movie. Use showTSeriesMovie to reshow a movie that has already
% been created. The vw.ui.movie field is cleared by recomputeImage which
% is called when you change scans, slices, or viewTypes.
%
% anatFlag: superimpose functional movie in pseudo-color on the 
% inplane anatomy.
%
% djh, 12/30/98
% ras, 05/01/04: turned off 'true size' option for the 
% figure and made the fig size reasonably large.

if ~strcmp(vw.viewType,'Inplane')
    myErrorDlg('makeFunctionalMovie: only for inplane views');
end

if ~exist('scan','var') || isempty(scan)
    scan = getCurScan(vw);
end
if ~exist('slice','var') || isempty(slice)
    slice = viewGet(vw, 'Current Slice');
elseif slice == 0
    slice = sliceList(vw, scan);
end
if ~exist('anatFlag','var')  || isempty(anatFlag)
    anatFlag = 0;
end
if ~exist('thresh','var') || isempty(thresh)
    thresh = 180;
end

% Initialize movie
vw.ui.movie = [];
vw.ui.movie.scan = scan;
vw.ui.movie.slice = slice;

% Initialize figure
selectGraphWin; clf
% set(gcf,'Units','Normalized','Position',[.1 .1 .5 .5]);
set(gcf,'Name',['tSeries movie, scan ',num2str(scan),', slice ',num2str(slice)]);
%whitebg(gcf,[0 0 0]);
set(gcf,'DefaultTextColor','yellow');
set(gca,'Position',[0 0 1 1]);
if(anatFlag && isempty(vw.anat))
    vw = loadAnat(vw);
end
for(ii=1:length(slice))
    % Load tSeries
    tSeriesAll{ii} = loadtSeries(vw,scan,slice(ii));
end
histThresh = length(reshape([tSeriesAll{:}],1,[]))/1000;
[tsCnt, tsVal] = hist(reshape([tSeriesAll{:}],1,[]),100);
minval = tsVal(find(tsCnt>histThresh, 1 ));
maxval = tsVal(find(tsCnt>histThresh, 1, 'last' ));

dims = sliceDims(vw,scan);
nFrames = numFrames(vw,scan);

if anatFlag
    % Create a split colormap (0-127 = greyscale, 128-255 = hot)
    cmap = [repmat([0:1/127:1]',1,3); hot(128)];
    colormap(cmap);
    % Get anatomy image
    %anatIm = cropCurAnatSlice(vw);
    anatIm = makeMontage(vw.anat, slice);
    % Rescale anatIm
    anatIm = rescale2(anatIm,[min(anatIm(:)),max(anatIm(:))],[0,127]);
    image(uint8(anatIm));
    axis image; axis off;
    %vw.ui.movie.movie = moviein(nFrames);
    for f = 1:nFrames
        clear tSeries;
        for(ii=1:length(slice))
            tSeries(:,:,ii) = reshape(tSeriesAll{ii}(f,:),dims);
        end
        tSeries = makeMontage(tSeries);
        overlay = upSampleRep(tSeries,size(anatIm));
        overlay = rescale2(overlay,[minval,maxval],[128,255]);
        anatMask = overlay < thresh;
        im = overlay.*~anatMask + anatIm.*anatMask;
        image(uint8(im));
        axis image; axis off;
        text(10,10,num2str(f));
        vw.ui.movie.movie(f) = getframe;
    end
else
    colormap(gray(256));
    %im = uint8(rescale2(reshape(tSeries(1,:),dims),[minval,maxval],[0,255]));
    %image(im);
    axis image; axis off;
    vw.ui.movie.movie = moviein(nFrames);
    for f = 1:nFrames
        clear tSeries;
        for(ii=1:length(slice))
            tSeries(:,:,ii) = reshape(tSeriesAll{ii}(f,:),dims);
        end
        tSeries = makeMontage(tSeries);
        im = rescale2(tSeries,[minval,maxval],[0,255]);
        image(uint8(im));
        axis image; axis off; truesize;
        text(10,10,num2str(f));
        vw.ui.movie.movie(f) = getframe;
    end
end

return