function [vw, M]  = callTSeriesMovie(vw)
% [vw, M] = callTSeriesMovie(vw);
%
% Simple dialog for setting params to call tSeriesMovie.
%
% 12/16/04 ras.
% 03/30/05 ras: loads the movie object into the view's ui.movie field,
% in lieu of the old matlab struct.
% 01/06/05 ras: added field for comparison frame.
% 11/07/06 ras: added field for slice selection.
prompt={'Scans:' ...
        'Slices: (>1 slice can be memory-hungry)' ...
        'Frames (vector; use 0 for all frames)' ...
        'Use Anat Image? (1 for yes, 0 for no):' ...
        'Clip values for functionals [min max]:' ...
        'Compare to a reference frame? (0 if no, else input frame #)' ...
        'Convert to % Signal? (1 for yes, 0 for no):' ...
        'Movie Frames per Second?' ...
        'Save as .AVI file? [Enter Path to export, or ''1'' for dialog]:' ...
        };
def={...
        num2str(1:viewGet(vw, 'numScans')) ...
        num2str(1:viewGet(vw, 'numSlices')) ...
        num2str([1 viewGet(vw, 'numFrames')]) ...
        '0' ...
        '[0 1]' ...
        '0' ...
        '0' ...
        '2' ...
        ''
    };
dlgTitle = 'Make Movie of time series w/ UI';
answer = inputdlg(prompt, dlgTitle, 1, def);
% if 'cancel' pressed, exit gracefully
if isempty(answer)
    return
end

% parse responses
scans           = str2num(answer{1});
slices          = str2num(answer{2});
frames          = str2num(answer{3});
anatFlag        = str2num(answer{4});
funcClip        = str2num(answer{5});
compareFrames   = str2num(answer{6});
convertToPct    = str2num(answer{7});
fps             = str2num(answer{8});
aviFlag         = answer{9};

if anatFlag==1
    applyHisto = 0;
else
    applyHisto = 0;
end
if convertToPct==1
    meanThresh = funcClip(1);
else
    meanThresh = 0;
end

if isequal(aviFlag,'1')
    aviPath = 'dialog';
elseif isequal(aviFlag,'0') || isempty(aviFlag)
    aviPath = '';
else 
    aviPath = aviFlag;
end

% call movie
[M vw.ui.movie] = tSeriesMovie(vw, scans, anatFlag, ...
                         'slices', slices, ...
                         'frames', frames, ...
                         'funcClip', funcClip, ...
                         'convertToPct', convertToPct, ...
                         'applyHisto', applyHisto, ...
                         'compareFrames', compareFrames, ...
                         'meanThresh', meanThresh, ...
                         'saveAvi', aviPath, ...
                         'fps', fps);
return
