function view = makeMultiLevelButtons(view);
%
% view = makeHemisphereButtons(view);
%
% For flat multi-level view: 
% Installs radio buttons that set whether to
% display flat data from tSeries averaged across 
% gray levels, or whether to display each gray level
% separately
%
% djh, 1/97 (makeHemisphereButtons)
% ras, 8/04 (makeMultiLevelButtons)

% Multi button Callback:
%   selectButton(view.ui.sliceButtons,1);
%   view=refreshScreen(view);
% The hemisphere buttons (off of which these buttons are hacked)
% pass a '2' in the recompute field of refreshView.
% This lets refreshView deal with the image rotation slider bar.
% I'm not sure if this is relevant to the gray levels, but I'll
% leave it in for now. -ras 08/04
callbackStr = ...
    ['selectButton(',view.name,'.ui.levelButtons,1); ',...
     'switch2AvgLevels(',view.name,'); ',...
	view.name,'=refreshScreen(',view.name,',2);'];

view.ui.levelButtons(1) = ...
    uicontrol('Style','radiobutton',...
    'String','Average',...
    'Units','normalized',...
    'BackgroundColor',get(gcf,'Color'),...
    'Position',[0 .65 .1 .05],...
    'Callback', callbackStr);

% Separate button Callback:
%   selectButton(view.ui.sliceButtons,1);
%   view=refreshScreen(view);
callbackStr = ...
    ['selectButton(',view.name,'.ui.levelButtons,2); ',...
     'switch2SeparateLevels(',view.name,'); ',...
	view.name,'=refreshScreen(',view.name,',2);'];
view.ui.levelButtons(2) = ...
    uicontrol('Style','radiobutton',...
    'String','Separate',...
    'BackgroundColor',get(gcf,'Color'),...
    'Units','normalized',...
    'Position',[0 .6 .1 .05],...
    'Callback', callbackStr);

return;
