function [repNumVec] = seqrepeats(vec);
% SEQREPEATS: count the sequential repeats in a vector.
% Usage: [repNumVec] = seqrepeats(vec);
%
% Given a vector input of length N, seqrepeats outputs a length-N vector whose elements represent the 
% occurrence "in a row" of the corresponding elements in the input vector. For instance, given a vector:
%
% 1 1 1 1 2 2 2 3 2 2 1
% 
% the output vector ('repeat number vector') would be:
%
% 1 2 3 4 1 2 3 1 1 2 1 
%
% 11/02 by ras
N = length(vec);
repNumVec = ones(size(vec));
for i = 2:N
	if vec(i)==vec(i-1)
		repNumVec(i) = repNumVec(i-1) + 1;
	end
end

return
