function vw=makeVolSliceUI(vw)
%Installs orientation buttons and edit fields for slice numbers
%
% vw=makeVolSliceUI(vw)
%
% Installs:
%   slice orientation buttons (axi=button 1, cor=button 2, sag=button 3)
%   editable text fields for slice numbers
%   prev and next push buttons
%
% djh, 7/98

% Slice orientation buttons
width = .1;
height = .05;
bot= .01;
buttonLabels=['Axi'; 'Cor'; 'Sag'];
for b = 1:3
  left = .25*(b-1) + 0.1;
  % Callback:
  %   selectButton(vw.ui.sliceOriButtons,b);
  %   vw=refreshScreen(vw);
  callbackStr = ...
      ['selectButton(',vw.name,'.ui.sliceOriButtons,',num2str(b),'); ',...
	  vw.name,'=refreshScreen(',vw.name,',2);'];
  vw.ui.sliceOriButtons(b) = ...
      uicontrol('Style','radiobutton',...
      'String',buttonLabels(b,:),...
      'Units','normalized',...
      'Position',[left,bot,width,height],...
      'Callback', callbackStr);
end

% Slice num fields
width = .1;
height = .05;
bot= .01;sz= viewSize(vw);
for b = 1:3
  left = .25*(b-1) + .2;
  % Callback:
  %   sliceNum=str2num(get(vw.ui.sliceNumFields(b),'String'));
  %   volSize=viewSize(vw);
  %   sliceNum=clip(sliceNum,1,volSize(b));
  %   set(vw.ui.sliceNumFields(b),'String',num2str(sliceNum));
  %   clear sliceNum volSize;
  %   vw=refreshScreen(vw);
  bstr=num2str(b);
  callbackStr = ...
      ['sliceNum=str2num(get(',vw.name,'.ui.sliceNumFields(',bstr,'),''String'')); '...
	  'volSize=viewSize(',vw.name,'); ',...
	  'sliceNum=clip(sliceNum,1,volSize(',bstr,')); '...
	  'set(',vw.name,'.ui.sliceNumFields(',bstr,'),''String'',num2str(sliceNum)); '...
	  'clear sliceNum volSize; ',...
	  vw.name,'=refreshScreen(',vw.name,',2);'];
  vw.ui.sliceNumFields(b) = ...
      uicontrol('Style','edit',...
      'BackgroundColor',[1 1 1],...
...%      'String',num2str(1),...
      'String',num2str(round(sz(b)/2)),...
      'Units','normalized',...
      'Position',[left,bot,width,height],...
      'Callback', callbackStr);
end


% Prev button
% Callback:
%   sliceNum=viewGet(vw, 'Current Slice')-1;
%   setCurSlice(vw,sliceNum);
%   clear sliceNum;
%   vw=refreshScreen(vw);
callbackStr = ...
    ['sliceNum=viewGet(',vw.name,', ''Current Slice'')-1; '...
	'vw = viewSet(',vw.name,',''Current Slice'', sliceNum); '...
	'clear sliceNum; ',...
	vw.name,'=refreshScreen(',vw.name,');'];
previousBtn= ...
    uicontrol('Style','pushbutton',...
    'String','<< Prev',...
    'Units','normalized',... 
    'Position',[.3 .07 .1 .05], ...
    'Callback', callbackStr);

% Next button
% Callback:
%   sliceNum=viewGet(vw, 'Current Slice')+1;
%   setCurSlice(vw,sliceNum);
%   clear sliceNum;
%   vw=refreshScreen(vw);
callbackStr = ...
    ['sliceNum=viewGet(',vw.name,', ''Current Slice'')+1; '...
	'vw = viewSet(',vw.name,',''Current Slice'', num2str(sliceNum)); '...
	'clear sliceNum; ',...
	vw.name,'=refreshScreen(',vw.name,');'];
nextBtn= ...
    uicontrol('Style','pushbutton',...
    'String','Next >>',...
    'Units','normalized',... 
    'Position',[.5 .07 .1 .05], ...
    'Callback', callbackStr);

return;
