function view = blurDialog(view);

if isempty(view)
   myErrorDlg('Volume window must be open to blur phase.');
   return;
end
if ~strcmp('Gray',view.viewType)
   myErrorDlg('Blur phase only in gray view.');
   return;
end
if (isempty(view.ph) | isempty(view.co))
   myErrorDlg('Correlation matrices not loaded.  Load them from the File menu');
   return;
end

% Make ui.blur structure
if ~isfield(view.ui,'blur');
    view.ui.blur = [];
end
if ~isfield(view.ui.blur,'Lambda');
   view.ui.blur.Lambda = 0;
end
if ~isfield(view.ui.blur,'weightFlag');
   view.ui.blur.weightFlag = 0;
end
  
windowPos = [150 200 300 50];

blurwin = figure('MenuBar','none');

set(blurwin,'Position', windowPos);
set(blurwin, 'Name', 'Blurring');

view.ui.blur.WindowHandle = gcf;

radioPos = [0.05 0.5 0.3 0.4];
radioOff = [0 0.4 0 0];
view.ui.blur.Radio(1) = uicontrol('Style','radiobutton',...
    'String','Blur',...
    'Units','normalized',...
    'Position',radioPos,...
    'Callback', [view.name,'.ui.blur.weightFlag=0; ',...
    'selectButton(',view.name,'.ui.blur.Radio,1)']);
view.ui.blur.Radio(2) = uicontrol('Style','radiobutton',...
    'String','Weighted blur',...
    'Units','normalized',...
    'Position',radioPos-radioOff,...
    'Callback', [view.name,'.ui.blur.weightFlag=1; ',...
    'selectButton(',view.name,'.ui.blur.Radio,2)']);
 
 % Select the appropriate radio button
 if view.ui.blur.weightFlag
    selectButton(view.ui.blur.Radio,2);
 else
    selectButton(view.ui.blur.Radio,1);
 end

view.ui.blur.SliderPos = [0.4 0.5 0.4 0.4];
view.ui.blur.LabelOffset = [0 0.4 0 0];

range = [-1 1];
sliderCallback = [view.name '.ui.blur.Lambda = get(' view.name '.ui.blur.Slider,''Value''); ',...
      'uicontrol(''Style'',''text'',''Units'',''normalized'',''Position'',',...
       view.name '.ui.blur.SliderPos - ',...
      view.name '.ui.blur.LabelOffset, ''String'',[''Blurring: '' num2str(10^(',...
      view.name '.ui.blur.Lambda))])'];
view.ui.blur.Slider = uicontrol('Style','slider',...
   'Units','normalized',...
   'Position',view.ui.blur.SliderPos,...
   'Min',range(1), 'Max',range(2),...
   'Value',view.ui.blur.Lambda,...
	'Callback',sliderCallback);

uicontrol('Style','text',...
   'Units','normalized',...
   'Position',view.ui.blur.SliderPos - view.ui.blur.LabelOffset,...
   'String',['Blurring: ' num2str(10^(view.ui.blur.Lambda))]);
OKposition = [0.85 0.1 0.1 0.8];
uicontrol('String','Blur',...
   'Units','normalized',...
   'Position', OKposition,...
   'Callback', ['close(',num2str(view.ui.blur.WindowHandle),'); ',...
      view.name,' = blurPh(',view.name,...
      ',',view.name,'.ui.blur.weightFlag',...
      ',10^(',view.name,'.ui.blur.Lambda)); ',...
      view.name,'=refreshScreen(',view.name,',1);']);
