function shiftTSeries(view,shift,scanList)
%
% function shiftTSeries(view,[shift],[scanList])
%
% Shifts the time series (circular shift), to advance the phase of the response.
% This is useful for approximately compensating for the hemodynamic delay before
% averaging across scans, especially for CW and CCW retinotopies.
%
% scanList: vector of scan numbers to flip. Default: prompt user.
% shift: number of frames to shift. Default: 1.
%
% If you change this function make parallel changes in:
%    flipTSeries
% 
% djh, 6/2001
if ieNotDefined('scanList'),  scanList = er_selectScans(view); end
if ieNotDefined('shift'),     shift = 1;                       end

waitHandle = waitbar(0,'Shifting tSeries.  Please wait...');

for iScan=1:length(scanList)

    scan = scanList(iScan);
    
    for slice=sliceList(view,scan);
        tSeries = loadtSeries(view,scan,slice);
        tSeries = circularShift(tSeries,0,-shift);
        savetSeries(tSeries,view,scan,slice);
        waitbar(iScan/length(scanList))
    end 
end

close(waitHandle);

if length(scanList)==1
    fprintf('Shifted tSeries for scan %i by %i frames.\n',scanList,shift);
else
    fprintf('Shifted tSeries for scans %s by %i frames.\n',...
        num2str(scanList),shift);
end    

return
