function ui = mrViewROIPanel(ui, dockFlag, vis);
%  ui = mrViewROIPanel(ui, [dockFlag], [vis=0]);
%
% Adds a panel or window to the mrViewer UI with
% controls for creating,  modifying,  and deleting Regions
% of Interest (ROIs).
%
% dockFlag: if 1,  will attach panel to the 
% mrViewer figure. Otherwise,  will make a 
% separate figure for the panel.
%
% vis: if 0, will initialize the panel to be hidden (default when
% starting up mrViewer); otherwise, leave it visible (as when 
% docking/undocking the panel).
%
% ras,  08/20/05.
if ~exist('ui', 'var') | isempty(ui),  ui = mrViewGet; end
if ~exist('dockFlag', 'var') | isempty(dockFlag),  dockFlag = 1; end
if ~exist('vis', 'var') | isempty(vis),  vis = 0; end

%%%%%Create the panel
if dockFlag==1
    ui.panels.roi= mrvPanel('above', 80, ui.fig, 'pixels');
else
    hfig = figure('Name', sprintf('ROIs [%s]', ui.tag), ...
                  'Units', 'normalized', ...
                  'Position', [.12 .89 .33 .08], ...
                  'MenuBar', 'none', ...
                  'NumberTitle', 'off', ...
                  'UserData', ui.tag);              
    ui.panels.roi = uipanel('Parent', hfig, 'Units', 'normalized', ...
                               'Position', [0 0 1 1]);
	% close request function for this figure: just toggle visibility
    crf = 'tmp = findobj(''Parent'', gcf, ''Type'', ''uipanel''); ';
    crf = [crf 'mrvPanelToggle(tmp); clear tmp;'];
    set(hfig, 'CloseRequestFcn', crf);
end

fgColor = [0 0 0];
bgColor = [.9 .9 .9];
set(ui.panels.roi, 'Units', 'normalized', 'BackgroundColor', bgColor, ...
    'BorderType', 'none', 'ShadowColor', bgColor, 'Title', '');
                    
%%%%%add a popup for selecting edit mode
modes = {'Rectangle' 'Circle' 'Cube' 'Sphere' 'Line' 'Point' 'Blob'};
cb = 'mrViewSet([],  ''roiEditMode'',  get(gcbo, ''Value'')); ';
ui.controls.roiEditMode = uicontrol('Parent', ui.panels.roi, ...
    'Style', 'popup', 'String', modes, 'Value', ui.settings.roiEditMode, ...
    'Callback', cb, ...
    'ForegroundColor', fgColor, 'BackgroundColor', bgColor, ...
    'Units', 'normalized', 'Position', [0 .05 .2 .45]);

%%%%%add buttons for adding to,  removing from,  creating new, 
%%%%%and deleting ROIs
cb = 'mrViewROI(''add'');';
ui.controls.roiAdd = uicontrol('Parent', ui.panels.roi, ...
    'Style', 'pushbutton', 'String', 'Add', 'Callback', cb, ...
    'ForegroundColor', fgColor, 'BackgroundColor', [.8 .8 .9], ...
    'Units', 'normalized', 'Position', [0 .5 .1 .4]);

cb = 'mrViewROI(''remove'');';
ui.controls.roiRemove = uicontrol('Parent', ui.panels.roi, ...
    'Style', 'pushbutton', 'String', 'Remove', 'Callback', cb, ...
    'ForegroundColor', fgColor, 'BackgroundColor', [.8 .8 .9], ...
    'Units', 'normalized', 'Position', [.1 .5 .1 .4]);

cb = 'mrViewROI(''new'');';
ui.controls.roiNew = uicontrol('Parent', ui.panels.roi, ...
    'Style', 'pushbutton', 'String', 'New', 'Callback', cb, ...
    'ForegroundColor', fgColor, 'BackgroundColor', [.8 .8 .9], ...
    'Units', 'normalized', 'Position', [.22 .66 .17 .3]);

cb = 'mrViewROI(''edit'');';
ui.controls.roiEdit = uicontrol('Parent', ui.panels.roi, ...
    'Style', 'pushbutton', 'String', 'Edit', 'Callback', cb, ...
    'ForegroundColor', fgColor, 'BackgroundColor', [.8 .8 .9], ...
    'Units', 'normalized', 'Position', [.22 .34 .17 .3]);

cb = 'mrViewROI(''delete'');';
ui.controls.roiDelete = uicontrol('Parent', ui.panels.roi, ...
    'Style', 'pushbutton', 'String', 'Delete', 'Callback', cb, ...
    'ForegroundColor', fgColor, 'BackgroundColor', [.8 .8 .9], ...
    'Units', 'normalized', 'Position', [.22 .02 .17 .3]);

cb = 'mrViewROI(''restrict'');';
ui.controls.roiRestrict = uicontrol('Parent', ui.panels.roi, ...
    'Style', 'pushbutton', 'String', 'Restrict', 'Callback', cb, ...
    'ForegroundColor', fgColor, 'BackgroundColor', [.8 .8 .9], ...
    'Units', 'normalized', 'Position', [.44 .66 .17 .3]);


%%%%%add buttons for plotting time courses and
%%%%%saving ROIs to sessions
cb = 'mrViewTimeCourse;';
ui.controls.roiTimeCourse = uicontrol('Parent',  ui.panels.roi, ...
    'Style',  'pushbutton',  'String',  'Time Course',  'Callback',  cb, ...
    'ForegroundColor',  fgColor,  'BackgroundColor',  [.8 .8 .9], ...
    'Units', 'normalized',  'Position',  [.44 .34 .17 .3]);

cb = 'mrViewROI(''save'');';
ui.controls.roiSave = uicontrol('Parent',  ui.panels.roi, ...
    'Style',  'pushbutton',  'String',  'Save',  'Callback',  cb, ...
    'ForegroundColor',  fgColor,  'BackgroundColor',  [.8 .8 .9], ...
    'Units', 'normalized',  'Position',  [.44 .02 .17 .3]);

% For mrVista 2, these buttons should only be visible if there's a
% session GUI:
if isempty(findobj('Tag', 'mrVista Session GUI'))
    set(ui.controls.roiTimeCourse,  'Visible',  'off');
    set(ui.controls.roiSave,  'Visible',  'off');
end


%%%%%add a popup for selecting the current ROI
cb = 'mrViewROI(''select'', get(gcf, ''UserData''), get(gcbo, ''Value'')); ';
ui.controls.roiSelect = uicontrol('Parent', ui.panels.roi, ...
    'Style', 'popup', 'String', {'(No ROIs)'}, 'Value', 1, ...
    'ForegroundColor', fgColor, 'BackgroundColor', bgColor, ...
    'Units', 'normalized', 'Position', [.77 .5 .2 .45], 'Callback', cb);

% label
uicontrol('Parent', ui.panels.roi, 'Style', 'text', 'String', 'Current ROI:', ...
    'ForegroundColor', fgColor, 'BackgroundColor', bgColor, ...
   'Units', 'normalized', 'Position', [.65 .5 .12 .45], 'Callback', cb);


%%%%%add a popup for selecting ROI view mode
viewModes = {'Hide ROIs' 'Current ROI' 'All ROIs'};
cb = 'ui=mrViewSet([],  ''roiViewMode'');';
ui.controls.roiViewMode = uicontrol('Parent', ui.panels.roi, ...
    'Style', 'popup', 'String', viewModes, 'Value', ui.settings.roiViewMode, ...
    'ForegroundColor', fgColor, 'BackgroundColor', bgColor, ...
    'Units', 'normalized', 'Position', [.77 .05 .2 .45], 'Callback', cb);

% label
uicontrol('Parent', ui.panels.roi, 'Style', 'text', 'String', 'Show:', ...
    'ForegroundColor', fgColor, 'BackgroundColor', bgColor, ...
   'Units', 'normalized', 'Position', [.65 .05 .12 .45], 'Callback', cb);

%%%%%hide the panel
if vis==0
	mrvPanelToggle(ui.panels.roi, 'off');    
end


return
