function ui = mrViewOverlayPanel(ui, dockFlag, o);
%
% ui = mrViewOverlayPanel([ui, dockFlag, o]);
%
% Create a new panel/window for UI controls related
% to a new overlay. Also attach a panel containing
% colorbar axes to the main figure.
%
% dockFlag: if 1,  will attach panel to the
% mrViewer figure. Otherwise,  will make a
% separate figure for the panel.
%
% ras,  07/05.
if ~exist('ui', 'var') | isempty(ui),  ui = mrViewGet;            end
if ishandle(ui),  ui = get(ui, 'UserData'); end
if ~exist('dockFlag', 'var') | isempty(dockFlag),  dockFlag = 0;  end
if ~exist('o', 'var') | isempty(o),  o = length(ui.overlays);     end

% javaFigs = feature('javafigures');
% if ispref('VISTA', 'javaOn') 
%     feature('javafigures', getpref('VISTA', 'javaOn'));
% else
%     feature('javafigures', 0);
% end
javaFigs = mrvJavaFeature;
 
m = ui.overlays(o).mapNum;

if dockFlag==1
    ui.panels.overlays(o) = mrvPanel('right', 150, ui.fig, 'pixels');
else
    % place in a separate window
    offset = [.1*(o-1) 0 0 0]; % move extra overlays further right
    hfig = figure('Name', sprintf('Overlay %i [%s]', o, ui.tag), ...
        'Units', 'normalized', ...
        'Position', [.65 .23 .12 .5] + offset, ...
        'MenuBar', 'none', ...
        'NumberTitle', 'off', ...
        'UserData', ui.tag);
    ui.panels.overlays(o) = uipanel('Parent', hfig, 'Units', 'normalized', ...
        'Position', [0 0 1 1]);

	% set the close request function such that closing this window actually
	% just toggles its visibility w/o destroying it
	crf = 'ui = mrViewGet; ';
    crf = [crf sprintf('mrvPanelToggle(ui.panels.overlays(%i));', o)];
    set(hfig, 'CloseRequestFcn', crf);
	
end

set(ui.panels.overlays(o), 'Units', 'normalized', ...
    'BackgroundColor', [.9 .9 .9], 'ShadowColor', [1 1 1], 'Title', '');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% callback for controls in this panel: % 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
cb = 'mrViewSetOverlay(gcf, get(gcbo, ''Parent''));';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% checkbox to hide overlay              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ui.overlays(o).hideCheck = uicontrol('Parent', ui.panels.overlays(o), ...
    'Style', 'checkbox', ...
    'String', '(Hide)', 'Units', 'normalized', ...
    'FontSize', 10, 'HorizontalAlignment', 'left', ...
    'BackgroundColor', [.9 .9 .9], ...
    'Callback', cb, 'Position', [.5 .95 .45 .04]);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% popup for selecting which map to use: %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mapNames = {ui.maps.name};
uicontrol('Parent', ui.panels.overlays(o), 'Style', 'text', ...
    'String', 'Map', 'Units', 'normalized', ...
    'FontSize', 12, 'HorizontalAlignment', 'left', ...
    'Position', [.05 .95 .4 .04]);
ui.overlays(o).mapPopup = uicontrol('Parent', ui.panels.overlays(o), ...
    'Style', 'popup', ...
    'String', mapNames, ...
    'Value', ui.overlays(o).mapNum, ...
    'Units', 'normalized', ...
    'Callback', cb, ...
    'Position', [.05 .9 .9 .05]);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% popup for selecting colormap:        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
prefOrder = {'hot' 'winter' 'redgreen' 'cool' 'autumn' ...
             'jet' 'gray' 'red' 'green' 'blue'}; % preferred order

uicontrol('Parent', ui.panels.overlays(o), 'Style', 'text', ...
    'String', 'Colormap', 'Units', 'normalized', ...
    'FontSize', 12, 'HorizontalAlignment', 'left', ...
    'Position', [.05 .85 .9 .04]);
ui.overlays(o).cmapPopup = uicontrol('Parent', ui.panels.overlays(o), ...
    'Style', 'popup', ...
    'String', mrvColorMaps, ...
    'Value', cellfind(mrvColorMaps, prefOrder{o}), ...
    'Units', 'normalized', ...
    'Callback', cb, ...
    'Position', [.05 .8 .9 .05]);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% controls for setting color range
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ui.overlays(o).climPopup = uicontrol('Parent', ui.panels.overlays(o), ...
                        'Style', 'popup', 'Units', 'normalized', ...
                        'Position', [.05 .75 .9 .05], ...
                        'String', {'Autoscale colors' 'Set Color Range'}, ...
                        'Value', 1, 'Callback', cb);
                    
ui.overlays(o).climText(1) = uicontrol('Parent', ui.panels.overlays(o), ...
          'Style', 'text', 'Units', 'normalized', ...
          'Position', [0 .7 .25 .04], 'String', 'Min:', 'Visible', 'off');
ui.overlays(o).climMin = uicontrol('Parent', ui.panels.overlays(o), ...
                        'Style', 'edit', 'Units', 'normalized', ...
                        'Position', [.25 .7 .25 .04], ...
                        'String', num2str(ui.maps(m).dataRange(1)), ...
                        'Visible', 'off', 'Callback', cb);                   

ui.overlays(o).climText(2) = uicontrol('Parent', ui.panels.overlays(o), ...
          'Style', 'text', 'Units', 'normalized', ...
          'Position', [.5 .7 .25 .04], 'String', 'Max:', 'Visible', 'off');
ui.overlays(o).climMax = uicontrol('Parent', ui.panels.overlays(o), ...
                        'Style', 'edit', 'Units', 'normalized', ...
                        'Position', [.75 .7 .25 .04], ...
                        'String', num2str(ui.maps(m).dataRange(2)), ...
                        'Visible', 'off', 'Callback', cb);                   
                    
                        
%%%%%%%%%%%%%%%%%%%%%%
% Threshold Controls %
%%%%%%%%%%%%%%%%%%%%%%
% range for threshold sliders
for j = 1:3
    
    % checkbox for turning on threshold:
    pos = [.05 .87-j*.2 .9 .04]; % empirically determined; sorry it's ugly
    ui.overlays(o).threshCheck(j) = uicontrol('Style', 'checkbox', ...
        'Parent', ui.panels.overlays(o), ...
        'String', sprintf('Threshold %i', j), ...
        'Value', 0, 'Min', 0, 'Max', 1, ...
        'FontSize', 10, ...
        'Units', 'normalized', ...
        'Position', pos, ...
        'Callback', cb);

    % popup for seleting map for threshold
    pos = [.05 .83-j*.2 .9 .04];
    ui.overlays(o).threshMap(j) = uicontrol('Style', 'popup', ...
        'Parent', ui.panels.overlays(o), ...
        'String', mapNames, ...
        'Value', m, ...
        'Units', 'normalized', ...
        'Callback', cb, ...
        'Visible', 'off', ...
        'Position', pos);

    % min/max sliders for threshold
    pos = [.05 .77-j*.2 .9 .06];
    ui.overlays(o).threshMin(j) = mrvSlider(pos, 'Min', ...
        'Parent', ui.panels.overlays(o), ...
        'intFlag', 0, 'SigFigs', 2, ...
        'Callback', cb, 'FontSize', 9, ...
        'Range', ui.maps(m).dataRange, ...
        'Val', ui.maps(m).dataRange(1), ...
        'MaxLabelFlag', 1, ...
        'Visible', 'off');

    pos = [.05 .71-j*.2 .9 .06];
    ui.overlays(o).threshMax(j) = mrvSlider(pos, 'Max', ...
        'Parent', ui.panels.overlays(o), ...
        'intFlag', 0, 'SigFigs', 2, ...
        'Callback', cb, 'FontSize', 9, ...
        'Range', ui.maps(m).dataRange, ...
        'Val', ui.maps(m).dataRange(2), ...
        'MaxLabelFlag', 1, ...
        'Visible', 'off');
end

% 4-th dimension slider for 4-D map data
map = ui.maps(ui.overlays(o).mapNum);
if length(map.dimUnits)>=4, label=map.dimUnits{4}; else, label = 'Time'; end
ui.overlays(o).time = mrvSlider([.05 .02 .9 .07], label, ...
    'Parent', ui.panels.overlays(o), ...
    'Units', 'normalized', ...
    'Range', [1 size(map.data, 4)], ...
    'cb', cb, ...
    'intFlag', 1, ...
    'SigFigs', 1, ...
    'maxLabelFlag', 1);
                        
% mrvSliderSet(ui.overlays(o).time, 'Units', 'normalized');
if ndims(map.data) < 4
    mrvSliderSet(ui.overlays(o).time, 'Visible', 'off');
end

% set bg color on controls to match panel
tmp = get(ui.panels.overlays(o), 'Children');
set(tmp, 'BackgroundColor', get(ui.panels.overlays(o), 'BackgroundColor'));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% controls to toggle panel visibility %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Make a menu toggle (in View | Overlays):
% callback for menu:
% ui = mrViewGet;
% mrvPanelToggle(ui.panels.overlays(o), gcbo);
cb = 'ui=mrViewGet; ';
cb = [cb sprintf('mrvPanelToggle(ui.panels.overlays(%i), gcbo);', o)];
ui.menus.overlayToggle(o) = uimenu(ui.menus.overlays, ...
    'Label', sprintf('Overlay %i', o), ...
    'Separator', 'off', ...
    'Checked', 'on', ...
    'Accelerator', num2str(5+o), ...
    'Callback', cb);

% make closing the figure just toggle its visibility
if dockFlag==0
    % close request function:
    % ui = mrViewGet;
    % mrvPanelToggle(ui.panels.overlays(o), ui.menus.overlayToggle(o));
    cb = 'ui=mrViewGet; ';
    cb = [cb sprintf('mrvPanelToggle(ui.panels.overlays(%i), ', o)];
    cb = [cb sprintf('ui.menus.overlayToggle(%i));', o)];
    set(hfig, 'CloseRequestFcn', cb);
end


% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % Create a color bar                  %
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ui = mrViewColorbarOpen(ui, o, prefOrder{o});                     
      
% feature('javafigures', javaFigs);
mrvJavaFeature(javaFigs);
return
