function ui = mrViewNavPanel(ui, dockFlag, vis);
%
% ui = mrViewNavPanel(ui, [dockFlag], [vis=1]);
%
% Add a navigation panel to a mrViewer UI.
% This panel will have the basic
% tools to navigate around the mr object, 
% and set the current view format.
%
% dockFlag: if 1,  will attach panel to the 
% mrViewer figure. Otherwise,  will make a 
% separate figure for the panel.
%
% vis: if 0, will hide the panel after making it. (Default is 1:
% keep visible).
% 
% ras,  07/05/05.
% ras,  07/15/05 -- now places the panel in a separate figure 
% by default.
if ~exist('ui', 'var') | isempty(ui),  ui = mrViewGet; end
if ~exist('dockFlag', 'var') | isempty(dockFlag),  dockFlag = 0; end
if ~exist('vis', 'var') | isempty(vis),  vis = 1; end

%%%%%%%%%%%%%%%%%%%%
% Create the panel %
%%%%%%%%%%%%%%%%%%%%
if dockFlag==1
    ui.panels.nav = mrvPanel('left', 0.2, ui.fig, 'normalized');
else
    hfig = figure('Name', sprintf('Navigation [%s]', ui.tag), ...
                  'Units', 'normalized', ...
                  'Position', [0 .23 .12 .5], ...
                  'MenuBar', 'none', ...
                  'NumberTitle', 'off', ...
                  'UserData', ui.tag);              
    ui.panels.nav = uipanel('Parent', hfig, 'Units', 'normalized', ...
                               'Position', [0 0 1 1]);

	% close request function for this figure: just toggle visibility
    crf = 'tmp = findobj(''Parent'', gcf, ''Type'', ''uipanel''); ';
    crf = [crf 'mrvPanelToggle(tmp); clear tmp;'];
    set(hfig, 'CloseRequestFcn', crf);
end

bgColor = [.9 .9 .9];
fgColor = [0 0 0];
set(ui.panels.nav, 'BackgroundColor', bgColor, ...
    'ShadowColor', bgColor, 'Title', '');
        
      
%%%%%%%%%%%%%%%%%%%% 
% add slice slider %
%%%%%%%%%%%%%%%%%%%% 
nSlices = size(ui.mr.data, 3);
if ui.mr.dims(3)==1
	% only one slice: we'll set dummy values and keep this slider hidden
	visible = 'off';
	sliceRange = [0 1];
	sliceStep = [.1 .4];
else
	visible = 'on';
	sliceRange = [1 nSlices];
	sliceStep = [1/nSlices 4/nSlices];
end
ui.slice = mrvSlider([.05 .93 .9 .06], 'Slice', ...
                        'Parent', ui.panels.nav, ...
                        'Units', 'normalized', ...
						'Visible', visible, ...
                        'Range', sliceRange, ...
                        'cb', 'mrViewSet([], ''Slice'');', ...
                        'intFlag', 1, ...
                        'SigFigs', 1, ...
                        'FontSize', 9, ...
                        'SliderStep', sliceStep, ...
                        'Value', ui.settings.slice, ...
                        'maxLabelFlag', 1);

%%%%% add set of radio buttons for selecting view orientation
names = {'Slice ' 'Column ' 'Row'};
cb = 'mrViewSet([], ''ori'', gcbo);  mrViewRefresh;';
ui.controls.ori = mrvButtons(fliplr(names), [.02 .69 .58 .16], ...
                            ui.panels.nav, cb, 0);
selectButton(ui.controls.ori, ui.settings.ori);
set(ui.controls.ori, 'ForegroundColor', fgColor);

% % label for set of buttons
% uicontrol('Parent', ui.panels.nav, 'Style', 'text', 'FontSize', 10, ...
%        'String', 'Orientation | Cursor Loc', 'BackgroundColor', bgColor, ...
%        'ForegroundColor', fgColor, 'FontAngle', 'Italic', ...
%        'HorizontalAlignment', 'left', ...
%        'FontWeight', 'bold', 'Units', 'normalized', 'Position', ...
%        [.02 .85 .9 .06]);

%%%%% add edit fields for each cursor location
cb = 'mrViewSet([], ''cursorLoc''); mrViewRefresh;';
ui.controls.cursorEdit(1) = uicontrol('Parent', ui.panels.nav, ...
                                'Style', 'edit', ...
                                'String', '1', ...
                                'Callback', cb, ...
                                'BackgroundColor', bgColor, ...
                                'Units', 'normalized', ...
                                'FontSize', 9, ...
                                'Position', [.6 .69 .37 .05]);
ui.controls.cursorEdit(2) = uicontrol('Parent', ui.panels.nav, ...
                                'Style', 'edit', ...
                                'String', '1', ...
                                'BackgroundColor', bgColor, ...
                                'Callback', cb, ...
                                'FontSize', 9, ...
                                'Units', 'normalized', ...
                                'Position', [.6 .74 .37 .05]);
ui.controls.cursorEdit(3) = uicontrol('Parent', ui.panels.nav, ...
                                'Style', 'edit', ...
                                'String', '1', ...
                                'Callback', cb, ...
                                'BackgroundColor', bgColor, ...
                                'FontSize', 9, ...
                                'Units', 'normalized', ...
                                'Position', [.6 .79 .37 .05]);
                            
%%%%% add set of radio buttons for selecting view format
formats = {'Single Slice' '3-Axis View' 'MontageView'};
cb = 'mrViewSet([], ''displayFormat'', gcbo); mrViewRefresh;';
ui.controls.displayFormat = mrvButtons(fliplr(formats), [.02 .5 .98 .15], ...
                              ui.panels.nav, cb, 0);
selectButton(ui.controls.displayFormat, ui.settings.displayFormat);                          
set(ui.controls.displayFormat, 'ForegroundColor', fgColor);

% % label for set of buttons
% uicontrol('Parent', ui.panels.nav, 'Style', 'text', 'FontSize', 10, ...
%        'String', 'Format', 'BackgroundColor', bgColor, ...
%        'ForegroundColor', fgColor, 'FontAngle', 'Italic', ...
%        'HorizontalAlignment', 'left', ...
%        'FontWeight', 'bold', 'Units', 'normalized', 'Position', ...
%        [.02 .65 .6 .06]);

%%%%% montage controls
cb = 'slider = get(gcbo, ''UserData'');'; 
cb = [cb ' val = get(slider.sliderHandle, ''Value'');'];
cb = [cb ' mrViewSet([], ''montageRows'', val); mrViewRefresh;'];
ui.controls.montageRows = mrvSlider([.05 .44 .9 .06], 'Rows', ...
                                   'Parent', ui.panels.nav, ...
                                   'IntFlag', 1, ...
                                   'Callback', cb, ...
                                   'FontSize', 9, ...
                                   'Range', [1 10], ...
                                   'Value', 2, ...
                                   'FlexFlag', 1);

cb = 'slider = get(gcbo, ''UserData'');'; 
cb = [cb ' val = get(slider.sliderHandle, ''Value'');'];
cb = [cb ' mrViewSet([], ''montageCols'', val); mrViewRefresh;'];
ui.controls.montageCols = mrvSlider([.05 .38 .9 .06], 'Columns', ...
                                   'Parent', ui.panels.nav, ...
                                   'intFlag', 1, ...
                                   'Callback', cb, ...
                                   'FontSize', 9, ...
                                   'Range', [1 10], ...
                                   'Val', 2, ...
                                   'flexFlag', 1);                        
mrvSliderSet(ui.controls.montageRows, 'Visible', 'off');
mrvSliderSet(ui.controls.montageCols, 'Visible', 'off');
               
%%%%% label slices toggle
cb = ' mrViewSet([], ''labelSlices'', get(gcbo, ''Value'')); mrViewRefresh;';
ui.controls.labelSlices = mrvButtons('Label Slices', [.05 .27 .9 .06], ...
                            ui.panels.nav, cb, 0);  
if ui.settings.labelSlices==1,  set(ui.controls.labelSlices, 'Value', 1); end                    

%%%%% cursor controls
cb = ' mrViewSet([], ''showCursor'', get(gcbo, ''Value'')); mrViewRefresh;';
ui.controls.cursor = mrvButtons('Show Cursor', [.05 .21 .9 .06], ...
                            ui.panels.nav, cb, 0);  
if ui.settings.showCursor==1,  set(ui.controls.cursor, 'Value', 1); end                    
                        
cursorTypes = {'+ Sign' 'Circle' 'Crosshairs' 'Crosshairs + Gap'};
cb = 'mrViewSet([], ''cursorType'', get(gcbo, ''Value'')); mrViewRefresh;';
ui.controls.cursorType = uicontrol('Parent', ui.panels.nav, ...
                                    'Style', 'popup', ...
                                    'String', cursorTypes, ...
                                    'Units', 'normalized', ...
                                    'Position', [.05 .15 .9 .06], ...
                                    'Value', ui.settings.cursorType, ...
                                    'FontSize', 10, ...
                                    'Callback', cb);
if ui.settings.showCursor==0
    set(ui.controls.cursorType, 'Visible', 'off');  
end


%%%%%%%%%%%%%%%%%%%% 
% add time slider  %
%%%%%%%%%%%%%%%%%%%% 
if length(ui.mr.dimUnits) >= 4
    labelText = ui.mr.dimUnits{4};
else
    labelText = 'Time Point';
end
ui.time = mrvSlider([.05 .09 .9 .06], labelText, ...
                        'Parent', ui.panels.nav, ...
                        'Units', 'normalized', ...
                        'Range', [1 size(ui.mr.data, 4)], ...
                        'cb', 'mrViewSet([], ''Time''); mrViewRefresh;', ...
                        'intFlag', 1, ...
                        'SigFigs', 1, 'FontSize', 9, ...
                        'maxLabelFlag', 1);
                        
mrvSliderSet(ui.time, 'Units', 'normalized');
if ndims(ui.mr.data) < 4
    mrvSliderSet(ui.time, 'Visible', 'off');
end

%%%%% add zoom buttons
ui.controls.zoomButton = uicontrol('Style', 'pushbutton', ...
                                  'String', 'Zoom', ...
                                  'Parent', ui.panels.nav, ...
                                  'FontSize', 10, ...
                                  'Units', 'normalized', ...
                                  'Position', [.05 .05 .9 .04], ...
                                  'BackgroundColor', [.6 .6 .6], ...
                                  'ForegroundColor', fgColor, ...
                                  'Callback', 'mrViewZoom;');
                              
ui.controls.resetZoomButton = uicontrol('Style', 'pushbutton', ...
                                  'String', 'Reset Zoom', ...
                                  'Parent', ui.panels.nav, ...
                                  'FontSize', 10, ...
                                  'Units', 'normalized', ...
                                  'Position', [.05 .01 .9 .04], ...
                                  'BackgroundColor', bgColor, ...
                                  'ForegroundColor', fgColor, ...
                                  'Callback', 'mrViewZoom([], ''reset'');');

set(ui.panels.nav, 'Units', 'normalized');

%%%%%hide the panel if needed
if vis==0
	mrvPanelToggle(ui.panels.nav, 'off');    
end

return                              
                         
