function [formats, filters, strs] = mrLoadFormats;
% The currently-accepted file formats for mrLoad. 
% Formats is a cell array of shorthand strings 
% describing each file type.
% Filters is a filter specifier that can be plugged in to
% uigetfile. strs is a set of patterns useable
% with strmatch (no asterisks) and the format names.
formats = {'mat', '*.mat',     'mrVista 2.0 mr file'; ...
           'nifti', '*.nii',    'NIFTI (*.nii*)'; ...
           'nifti', '*.gz',    'NIFTI compressed (*.nii.gz)'; ...
           'analyze', '*.img',  'Analyze 7.5 format (*.img)'; ...
           'analyze', '*.hdr',  'Analyze 7.5 format (*.hdr)'; ...
		   'vfiles', '*.img',   'All ANALYZE files in a directory'; ...
		   'dicom', '*.dcm',	'Single DICOM file'; ...
		   'dicomdir', '*.dcm',    'All DICOM files in directory'; ...
           'ifile',  'I*',      'All Genesis I-files in directory';  ...
           'pmag', '*.mag',     'P*.mag'; ...
		   'vmr',  '*.vmr',		'BrainVoyager VMR (*.vmr)'; ...
           'vanat', '*.dat',   'mrGray vAnatomy (*.dat)'; ...
		   'class', '*.class', 'mrGray classification file (*.class)'; ...
           '1.0tSeries', 'tSeries*', ...
                'mrVista 1.0 tSeries files (directory)'; ...
           '1.0anat', '*.mat', 'mrVista 1.0 anat file'; ...
           '1.0map', '*.mat', 'mrVista 1.0 map file'; ...
           '1.0corAnal','*.mat', 'mrVista 1.0 corAnal'; ...
           'bfloat', '*.bfloat', 'FS-FAST bfloat files (directory)'; ...
           'bshort', '*.bshort', 'FS-FAST bshort files (directory)'};

filters = formats(:,2:3);
formats = formats(:,1);
      
for i = 1:size(filters,1)
   strs{i} = filters{i,1};
   strs{i} = strs{i}(strs{i} ~= '*');
end

% add an 'all files' option for the filters
filters = [{'*.*' 'All Files'}; filters];

return