function found = roiExistName(view,roiName,fullMatch)
%
%      found = roiExistName(view,roiName,[fullMatch])
%
% Author: Wandell
% Purpose:
%
%   Check whether an ROI with roiName exists in the view.
%
%   If a full match to the roiName is not found, then we return
%   found=0.
%   
%   If a full match is found, view.ROIs(found) is the roi. 
%
%   If a partial match (fullMatch = 0) is requested, then roiExistName() can
%   find several matches (i.e., whenever the first part of the roiName matches
%   the roiName string). In this case, found returns a list of indices
%   whose names match the dataTypeName.  If no matches are found, then
%   found = 0 is returned.
%   
%   Examples:
%       roiExistName(FLAT{1},'Quad',0) returns a list of partial matches
%       FLAT{1}.ROIs(found).name all begin with the phrase 'Quad', such as
%       'Quad-1'.
%   

if ~exist('fullMatch','var'), fullMatch = 1; end
ROIs = view.ROIs;

nROIs = length(ROIs);

if fullMatch
    found = 0;
    for ii=1:nROIs
        if strcmp(ROIs(ii).name,roiName);
            found = ii;
            return;
        end
    end
else
    found = zeros(1,nROIs);
    for ii=1:nROIs
        found(ii) =  strncmp(ROIs(ii).name,roiName,length(roiName));
    end
    found = find(found);
    if isempty(found), found = 0; end
end

return;

