function dataOut=plotMultipleCo_PerCondition(view)
%
% dataOut=plotMultipleCo_PerCondition(view)
%
% Bar plot of the amplitudes for each scan, averaging across
% all pixels (in all slices) in a selection of ROIs. All y-axes are made the same. The bar heights
% and a coarse SEM can be obtained from get(gca,'UserData').
%
% gmb  5/25/98
% bw   2/19/99  Added seY field to the UserData field.
%	    seY is an estimate of the variability in the
%      amplitudes.  It is the SEM of the in the complex
%      (amp*exp(-i*ph)) representation.  The values are
%      computed in vectorMean.m
% fwc   11/07/02 plots data relative to current view
%       added plotting of multiple ROIs
%       ROI selection copied from plotMultipleTSeries.m


% Compute means across scans, for all pixels in the
% currently selected ROI.  The seZ value is the mean
% distance from the mean.
% This has no reference scan (it's an amplitude).
% It plots a separate window for each condition. Within this windows, it
% plots the amplitudes in each ROI.

%Reference scan is the current scan
mrGlobals;

refScan = getCurScan(view);

nROIs = length(VOLUME{1}.ROIs);

nscans = numScans(view);
ROIamps=zeros(nscans,nROIs);
ROIseZ=zeros(nscans,nROIs);
ROImeanPhs=zeros(nscans,nROIs);
ROIperVoxSem=zeros(nscans,nROIs);

for r=1:nROIs
    
    %n=selectedROIs(r);
    view = selectROI(view,r); % is there another way?
    [meanCo,meanAmp,stdCos,semCos] = meanCos(view);
    ROIco(:,r)=meanCo(:);
    ROIperVoxStd(:,r)=stdCos(:);
    ROIperVoxSem(:,r)=semCos(:);
    
    ROIseZ(:,r)=(meanAmp(:).^2)./meanCo(:);
    
    %xstr{r}=[view.ROIs(selectedROIs(r)).name];
    xstr{r}=int2str(r);
    roiName{r}=view.ROIs(r).name;
    fprintf(['\n#%d :',roiName{r}],r);
    
end
dataOut.ROIco=ROIco;
dataOut.ROIseZ=ROIseZ;
dataOut.ROIname=roiName;
dataOut.ROIperVoxStd=ROIperVoxStd;
dataOut.ROIperVoxSem=ROIperVoxSem;
% Now do the plotting

return;
