function dirS = GetDirEdit(dirS)

% dirS = GetDirEdit(dirS);
%
% Allow user to edit the fields of the session directory structure
% [dirS].

% The following two cell arrays determine the field names to
% display, their descriptive label, and whether or not they are
% to be editable. Each row of the array has the form:
% {field name, label, edit flag}.
dirFields = { ...
'home', 'Home (rw)', 1; ...
'raw', 'Raw (r)', 1; ...
};

% Create the top-level fields
% if isunix
% 
%   fontSize = 10;
% 
% else
%   fontSize = 9;
% 
% end
fontSize = 12;
titleFontSize = 12;
butWidth=10;
marginFields = 3.5;
topMargin = 1.5;
% scale factors for x and y axis coordinates
xs = 2.45;  
ys = 1.6;
height = 1 * ys;
vSkip = 0.10 * ys;
dy = (height + vSkip);
x = 1 * xs;

dirData = CreateEditData(dirFields, dirS);
numFields = length(dirData);
maxWidth = max([dirData.width]);
pos = [35, 3, maxWidth, (numFields+marginFields)] .* [2, ys, 2.1, dy];

% Create the figure:
topH = figure(...
    'MenuBar', 'none', ...
    'Units', 'char', ...
    'Position', pos, ...
    'Resize','off', ...
    'Name', 'FMRI Directories', ...
    'NumberTitle','off' ...
    );
bkColor = get(topH, 'color');
topHS = num2str(topH);

% Label the session parameters:
y = (numFields + marginFields - topMargin) * dy;
titleStr = 'Choose/modify these directories';
uicontrol( ...
    'Style', 'text', ...
    'Units', 'char', ...
    'String', titleStr, ...
    'BackgroundColor', bkColor, ...
    'Position', [0, y, length(titleStr)*xs*1.5, height*1.2], ...
    'HorizontalAlignment', 'left', ...
    'FontWeight', 'bold', ...
    'FontSize', titleFontSize ...
    );
maxLabelWidth = 0.9 * max(size(char(dirData.label), 2)) * xs;
y = y - dy;
% Create the edit fields:
for iField=1:numFields
  labelPos = [x, y, length(dirData(iField).label)*xs, height];
  h = CreateEditRow(dirData(iField), labelPos, maxLabelWidth, topH, ...
    fontSize, 'UpdateDirEdit');
  dirData(iField).handle = h;
  y = y - dy;
end


% Build the UI data structure and attach it to the figure:
uiData.dirS = dirS;
uiData.origDirS = dirS;
uiData.dirData = dirData;
set(topH, 'UserData', uiData);

% Finally, install the file-control buttons
y = y - dy/2;
butWidth = 11;
bpos = [x, y, butWidth, height*1.2];
uicontrol( ...
    'Style', 'pushbutton', ...
    'String', 'Accept', ...
    'Units', 'char', ...
    'HorizontalAlignment', 'center', ...
    'Position', bpos, ...
    'Callback', 'uiresume', ...
    'FontSize', titleFontSize ...
    );
x = x + butWidth + 1;
bpos = [x, y, butWidth, height*1.2];
uicontrol( ...
    'Style', 'pushbutton', ...
    'String', 'Revert', ...
    'Units', 'char', ...
    'HorizontalAlignment', 'center', ...
    'Position', bpos, ...
    'FontSize', titleFontSize, ...
    'Callback', ['RevertDirEdit(', topHS, ');'] ...
    );
x = x + butWidth + 1;
bpos = [x, y, butWidth, height*1.2];
uicontrol( ...
    'Style', 'pushbutton', ...
    'String', 'Cancel', ...
    'Units', 'char', ...
    'HorizontalAlignment', 'center', ...
    'Position', bpos, ...
    'FontSize', titleFontSize, ...
    'Callback', ['CancelEdit(', topHS, ');'] ...
    );

% Wait until we get a uiresume, then perform an update. Repeat
% this cycle until the update reports no errors.
ok = 0;
while ~ok
  uiwait(topH);
  uiData = get(topH, 'UserData');
  if isfield(uiData, 'cancel')
    dirS = [];
    close(topH);
    return
  end
  ok = UpdateDirEdit(topH);
end

% After the update is successful, unpack the data and clean up.
uiData = get(topH, 'UserData');
dirS = uiData.dirS;
close(topH);
