function saveLaminae(view)
%
%   saveLaminae(view)
%
% Save session laminar distance map in the view's
% subdirectory.
%
% Ress 6/04
fName = fullfile(viewDir(view), 'lamina.mat');
% Does file already exist?
%
if exist(fName, 'file')
    saveFlag = questdlg([fName, ' already exists. Overwrite?'],...
        'Save distance map?','Yes','No','No');
else
    saveFlag = 'Yes';
end
if strcmp(saveFlag, 'Yes')
    fprintf('Saving %s...', fName);
    laminae = view.laminae;
    save(fName, 'laminae');
    fprintf('done\n');
else
    fprintf('Distance map not saved');
end
