function tSeries = loadtSeries(vw,scan,slice)
% Returns the tSeries data for a specified scan and slice.
%
%       tSeries = loadtSeries(vw,scan,slice)
% 
% If scan or slice are not specified, then the routine uses the current
% scan or slice
%
% This routine handles various views
%
% DJH 1/9/98
% djh, 2/20/2001, removed interpolation, dumped dat files
% ras, 03/2007, moved to loading as single-precision

% Gray tSeries are stored differently, one per scan
% This is a bit ugly, but the only way to do it (for now). DJH
if strcmp(vw.viewType,'Gray'),  slice = 1; end
if notDefined('scan'),  scan  = viewGet(vw, 'curScan'); end
if notDefined('slice'), slice = viewGet(vw, 'curSlice'); end

dirPathStr = fullfile(tSeriesDir(vw),['Scan',int2str(scan)]);
fileName   = fullfile(dirPathStr,['tSeries',int2str(slice)]);

load(fileName,'tSeries');    % Load the variable tSeries
nFrames = size(tSeries,1);   %#ok<NODEF>
if (nFrames ~= viewGet(vw,'nFrames',scan))
    disp('loadtSeries: unexpected number of tSeries frames in file.');
end
nPixels = size(tSeries,2);

% size check:
% ras 05/13/05, made it not do this for flat tSeries, since these
% depend on the # of nodes, not the slice dims
%% if (nPixels ~= prod(viewGet(vw, 'sliceDims', scan))) && ~(isequal(vw.viewType,'Flat'))
%% change AG 2July 2014 - prod no longer supports ints so cast to double
if (nPixels ~= prod(double(viewGet(vw, 'sliceDims', scan)))) && ~(isequal(vw.viewType,'Flat'))
       disp('loadtSeries: unexpected number of pixels in TSeries.');
end
tSeries = single(tSeries);

return

