function exp7_block6_contrasts(view);
%
% exp7_block6_contrasts(view);
%
% Compute contrast maps for 6-position experiment.
%
% ras, 02/2008.
if notDefined('view'), view = getCurView; end

contrasts = { ...
			[1:18] [0] 'ObjVBlank'; ...
			[1:6] [0] 'FaceVBlank'; ...
			[7:12] [0] 'LimbVBlank'; ...
			[13:18] [0] 'HouseVBlank'; ...
			[1:6:18] [0] 'FovealVBlank'; ...
			[2:6:18] [0] 'UpVBlank'; ...
			[3:6:18] [0] 'RightVBlank'; ...
			[4:6:18] [0] 'DownVBlank'; ...
			[5:6:18] [0] 'Left4VBlank'; ...
			[6:6:18] [0] 'Left9VBlank'; ...
			[1:6] [7:12] 'FaceVLimb'; ...
			[7:12] [13:18] 'LimbVHouse'; ...
			[1:6] [13:18] 'FaceVHouse'; ...
			[4:6:18] [2:6:18] 'DownVUp'; ...
			[5:6:18] [3:6:18] 'LeftVRight'; ...
			[1:6:18] setdiff(1:18, [1:6:18]) 'FovealVOther'; ...
			[5:6:18] [6:6:18] 'Left4VLeft9'; ...
			};
		
for n = 1:size(contrasts, 1)
	computeContrastMap2(view, contrasts{n,1}, contrasts{n,2}, contrasts{n,3});
end
		
return
		