function mv = mv_plotsMenu(mv,hfig);
%
% mv = mv_plotsMenu(mv,hfig);
%
% Attach menus providing plotting options for
% the MultiVoxel UI.
%
% ras, 04/05
if ieNotDefined('hfig')
    hfig = gcf;
end

if ieNotDefined('mv')
    mv = get(hfig,'UserData');
end

mv.ui.plotMenu = uimenu('ForegroundColor', 'k', 'Label', 'Plot', ...
                        'Separator', 'on');

h(1) = uimenu(mv.ui.plotMenu,'Label','Whole Time Course For Each Voxel',...
        'Separator','off',...
        'Accelerator','J',...
        'CallBack','mv_selectPlotType(1); mv_plotWholeTc;');

h(2) = uimenu(mv.ui.plotMenu,'Label','Mean Amps: Voxel by Condition',...
        'Separator','off',...
        'Accelerator','M',...
        'CallBack','mv_selectPlotType(2); mv_plotAmps([],[2 3]);');

h(3) = uimenu(mv.ui.plotMenu,'Label','Mean Amps Subplots',...
        'Separator','off',...
        'Accelerator','B',...
        'CallBack','mv_selectPlotType(3); mv_ampsSubplots;');

h(4) = uimenu(mv.ui.plotMenu, 'Label', 'Mean Amps Subplots (remove means)', ...
        'Separator', 'off', ...
		'Accelerator', 'V', ...
        'CallBack','mv_selectPlotType(4); mv_ampsSubplots([],[],[],1);');

h(5) = uimenu(mv.ui.plotMenu,'Label','Mean Amps: Trial by Voxel by Condition',...
        'Separator','off',...
        'CallBack','mv_selectPlotType(5); mv_plotAmps([],[1 2 3]);');   
	
h(6) = uimenu(mv.ui.plotMenu,'Label','Histograms',...
        'Separator','on',...
        'Accelerator','H',...
        'CallBack','mv_selectPlotType(6); mv_histograms; ');       

h(7) = uimenu(mv.ui.plotMenu,'Label','Cross-Correlation Matrix',...
        'Separator','off',...
        'Accelerator','R',...
        'CallBack','mv_selectPlotType(7); mv_corrcoef; ');       	
	
h(8) = uimenu(mv.ui.plotMenu,'Label','Cross-Correlation Matrix (remove means)',...
        'Separator','off',...
        'Accelerator','T',...
        'CallBack','mv_selectPlotType(8); mv_corrcoef([], 1); ');       	
	
h(9) = uimenu(mv.ui.plotMenu,'Label','Visualize GLMs',...
        'Separator','on',...
        'Accelerator','G',...
        'CallBack','mv_selectPlotType(9); mv_visualizeGlm; ');       

mv.ui.plotHandles = h;


return
