function svm = svmRemove(svm, indices)
% svm = svmRemove(svm, indices)
% SUPPORT VECTOR MACHINE - REMOVE
% ---------------------------------------------------------
% Removes the specified condition from the SVM structure, patching up any
% holes it leaves in the order of the condition numbers.
%
% INPUTS
%   svm - Structure generated by svmInit.
%   indices - Vector of indices to remove from SVM structure.
%
% OUTPUTS
%   svm - Structure with specified indices removed.
%
% USAGE
%   After generating an SVM structure, removing conditions 2 and 3.
%       svm = svmInit(...);
%       svm = svmRemove(svm, [2 3]);
%   
% See also SVMINIT, SVMRUN, SVMEXPORTMAP, SVMBOOTSTRAP, SVMRELABEL,
% SVMRUNOPTIONS, SLINIT.
%
% renobowen@gmail.com [2010]
%
    keepIndices = ~ismember(svm.group, indices);
    svm.run = svm.run(keepIndices, :);
    svm.group = svm.group(keepIndices, :);
    svm.trial = svm.trial(keepIndices, :);
    svm.data = svm.data(keepIndices, :);
    
    combineInto = min(svm.group);
    svm = svmRelabel(svm, [combineInto indices], svm.grouplabel{combineInto});
end