function M = rmPlotGUI_openFig(M)
% Open the rmPlot GUI figure.
%
%  M = rmPlotGUI_openFig(M);
%
% ras, 11/2008.

% switch for dealing with java figures
javaFigs = mrvJavaFeature;

%% open the figure
figName = sprintf('rmPlotGUI %s (%s)', M.roi.name, M.dataType);
M.fig = figure('Color', 'w', 'Name', figName, ...
			   'Units', 'pixels', 'Position', [100 100 800 480]);
% 			   'Units', 'norm', 'Position', [.1 .2 .7 .5]);

%% create axes		   
% create a set of axes for displaying the receptive field
M.ui.rfAxes = subplot('Position', [.05 .5 .45 .45]);

% create a set of axes for showing the time series / prediction / RSS
M.ui.tsAxes = subplot('Position', [.05 .05 .7 .35]);

%% create sliders / text controls
% model selection box
callback = 'rmPlotGUI(''update'');';
M.ui.model = uicontrol('Style', 'popupmenu', ...
    'Units', 'norm', 'Position', [.8 .85 .15 .1], ...
    'BackgroundColor', 'w', 'FontSize', 9, ...
    'Callback', callback, ...
    'String', M.modelNames, 'Value', 1);

% voxel selection slider
M.ui.voxel = mrvSlider([.8 .78 .15 .06], 'Voxel', ...
    'Range', [1 size(M.tSeries, 2)], 'IntFlag', 1, 'Value', 1, ...
    'MaxLabelFlag', 1, 'FontSize', 9, ...
    'Color', 'w', 'Callback', callback);

% toggle checkbox for superimposing the stimulus image
M.ui.overlayStimCheck = uicontrol('Style', 'checkbox', ...
    'Units', 'norm', 'Position', [.8 .72 .15 .06], ...
    'BackgroundColor', 'w', 'FontSize', 9, ...
    'Callback', callback, 'Min', 0, 'Max', 1, ...
    'String', 'Overlay Stimulus on PRF', 'Value', 0);

% time point selection slider (for stimulus overlay)
M.ui.time = mrvSlider([.8 .64 .15 .06], 'Time Frame', ...
    'Range', [1 size(M.tSeries, 1)], 'IntFlag', 1, 'Value', 1, ...
	'FontSize', 9, ...
    'MaxLabelFlag', 1, 'Visible', 'off', ...
    'Color', 'w', 'Callback', callback);


%-------------------------------------------------------------------
% jw: Manually adjust the pRF fit paramaters?
% ras: added a pRF size adjust. The toggle to show these sliders will now
% be placed in the menus (see rmPlotGUI_menus).

% sliders for manual adjustment of x, y, sigma 
tmp = M.params.analysis.maxRF;
M.ui.moveX = mrvSlider([.8 .4 .15 .05], 'x', ...
    'Range', [-tmp tmp], 'IntFlag', 0, 'Value', 0, ...
	'FlexFlag', 1, 'FontSize', 8, ...
	'MaxLabelFlag', 1, 'Visible', 'off', ...
    'Color', 'w', 'Callback', callback);

M.ui.moveY = mrvSlider([.8 .35 .15 .05], 'y', ...
    'Range', [-tmp tmp], 'IntFlag', 0, 'Value', 0, ...
	'FlexFlag', 1, 'FontSize', 8, ...
	'MaxLabelFlag', 1, 'Visible', 'off', ...
    'Color', 'w', 'Callback', callback);

M.ui.moveSigma = mrvSlider([.8 .3 .15 .05], 'sigma', ...
    'Range', [0.01 15], 'IntFlag', 0, 'Value', .1, ...
	'FlexFlag', 1, 'FontSize', 8, ...
    'MaxLabelFlag', 1, 'Visible', 'off', ...
    'Color', 'w', 'Callback', callback);

%-------------------------------------------------------------------

% toggle checkboxes for time series, model prediction, and residuals
callback = ['opt = get(gcbo, ''Value'') + 1;  tmp = {''off'' ''on''}; ' ...
    'set( get(gcbo, ''UserData''), ''Visible'', tmp{opt} ); ' ...
    'clear opt tmp; '];

M.ui.tsCheck = uicontrol('Style', 'checkbox', ...
    'Units', 'norm', 'Position', [.8 .1 .15 .06], ...
    'BackgroundColor', 'w', 'FontSize', 10, ...
    'Callback', callback, 'Min', 0, 'Max', 1, ...
    'String', 'Voxel Time Series', 'Value', 1);

M.ui.predCheck = uicontrol('Style', 'checkbox', ...
    'Units', 'norm', 'Position', [.8 .16 .15 .06], ...
    'BackgroundColor', 'w', 'FontSize', 10, ...
    'Callback', callback, 'Min', 0, 'Max', 1, ...
    'String', 'Prediction', 'Value', 1);

M.ui.resCheck = uicontrol('Style', 'checkbox', ...
    'Units', 'norm', 'Position', [.8 .22 .15 .06], ...
    'BackgroundColor', 'w', 'FontSize', 10, ...
    'Callback', callback, 'Min', 0, 'Max', 1, ...
    'String', 'Residuals', 'Value', 0);


% add text uicontrols which will contain outputs on the calculations
M.ui.coordsText = uicontrol('Style', 'text', ...
	'HorizontalAlignment', 'left', ...	
    'Units', 'norm', 'Position', [.5 .85 .2 .06], ...
    'BackgroundColor', 'w', 'FontSize', 9, ...
    'FontWeight', 'bold', 'String', '');

M.ui.r2Text = uicontrol('Style', 'text', ...
	'HorizontalAlignment', 'left', ...
    'Units', 'norm', 'Position', [.5 .79 .2 .06], ...
    'BackgroundColor', 'w', 'FontSize', 9, ...
    'FontWeight', 'bold', 'String', '');

M.ui.xyText = uicontrol('Style', 'text', ...
	'HorizontalAlignment', 'left', ...
    'Units', 'norm', 'Position', [.5 .73 .15 .06], ...
    'BackgroundColor', 'w', 'FontSize', 9, ...
    'FontWeight', 'bold', 'String', '');

M.ui.rthText = uicontrol('Style', 'text', ...
	'HorizontalAlignment', 'left', ...
    'Units', 'norm', 'Position', [.5 .67 .15 .06], ...
    'BackgroundColor', 'w', 'FontSize', 9, ...
    'FontWeight', 'bold', 'String', '');

M.ui.sigmaText = uicontrol('Style', 'text', ...
	'HorizontalAlignment', 'left', ...
    'Units', 'norm', 'Position', [.5 .61 .15 .06], ...
    'BackgroundColor', 'w', 'FontSize', 9, ...
    'FontWeight', 'bold', 'String', ''); % 'Interpreter', 'tex',

M.ui.betaText = uicontrol('Style', 'text', ...
	'HorizontalAlignment', 'left', ...
    'Units', 'norm', 'Position', [.5 .55 .15 .06], ...
    'BackgroundColor', 'w', 'FontSize', 9, ...
    'FontWeight', 'bold', 'String', '');


%% Add menus
M = rmPlotGUI_menus(M);

%% lastly, initialize the GUI graphics by performing an update:
set(M.fig, 'UserData', M);
rmPlotGUI_update;

mrvJavaFeature(javaFigs);

return
%--------------------------------------



%--------------------------------------
function M = rmPlotGUI_menus(M);
%% add menus to the GUI window.
set(M.fig, 'MenuBar', 'none');
M.ui.menus = uimenu(M.fig, 'Label', 'PRF Plot Options', 'Separator', 'on');

% temporally blur time series  (a hack, there should be a better way)
cb = ['TMP = get(gcf, ''UserData''); ' ...
	  'for v = 1:size(TMP.tSeries, 2), ' ...
	  '   TMP.tSeries(:,v) = imblur( TMP.tSeries(:,v) ); ' ...
	  'end; ' ...
	  'set(gcf, ''UserData'', TMP); ' ...
	  'clear TMP v; ' ...
	  'rmPlotGUI(''update''); '];
uimenu(M.ui.menus, 'Label', 'Temporally blur time series', ...
	   'Callback', cb, 'Separator', 'off');
   
% Dump data to workspace
callback = ['M = get(gcf, ''UserData''); ' ...
			'tmp = M.currTsdata; '...
			'disp(''Full model data in "M". Plot data in "tmp".'') '];
uimenu(M.ui.menus, 'Label', 'Dump Plot Data to Workspace', ...
	   'Callback', callback, 'Separator', 'off');

% toggle for (temporarily) editing the pRF parameters
callback = ['umtoggle(gcbo); rmPlotGUI(''update''); ']; 
M.ui.movePRF = uimenu(M.ui.menus, 'Label', 'Adjust pRF', ...
					 'Separator', 'on', ...
					 'Callback', callback, 'Checked', 'off');

% scale pRF to peak or max
M.ui.peakCheck = uimenu(M.ui.menus, 'Label', 'Scale to peak', ...
					 'Separator', 'on', 'Checked', 'off', ...
					 'Callback', callback);

% recompute betas?
M.ui.recompFit = uimenu(M.ui.menus, 'Label', 'Recompute fit', ...
					 'Separator', 'off', 'Checked', 'on', ...
					 'Callback', callback);
				 
% turn on grid when plotting pRFs?
M.ui.grid = uimenu(M.ui.menus, 'Label', 'Show Grid on pRF plot', ...
					'Separator', 'off', 'Checked', 'off', ...
					'Callback', callback);
				 
				 
% add a menu option that will toggle the rest of the toolbar menus
addFigMenuToggle(M.ui.menus);   


%% second menu, for sorting options
M.ui.sortMenu = uimenu(M.fig, 'Label', 'Sort / Select voxels', 'Separator', 'off');

% sort voxels by percent variance explained
uimenu(M.ui.sortMenu, 'Label', 'Sort Voxels by variance explained', ...
	   'Callback', 'rmPlotGUI_sortVoxels(''varexp''); ', 'Separator', 'off');
   
% sort voxels by percent variance explained
uimenu(M.ui.sortMenu, 'Label', 'Sort Voxels by negative variance explained', ...
	   'Callback', 'rmPlotGUI_sortVoxels(''varexpneg''); ', 'Separator', 'off'); 
   
% sort voxels by eccentricity
uimenu(M.ui.sortMenu, 'Label', 'Sort Voxels by eccentricity', ...
	   'Callback', 'rmPlotGUI_sortVoxels(''ecc''); ', 'Separator', 'off');

% sort voxels by polar angle
uimenu(M.ui.sortMenu, 'Label', 'Sort Voxels by polar angle', ...
	   'Callback', 'rmPlotGUI_sortVoxels(''pol''); ', 'Separator', 'off');
   
% sort voxels by pRF size
uimenu(M.ui.sortMenu, 'Label', 'Sort Voxels by pRF size (sigma major)', ...
	   'Callback', 'rmPlotGUI_sortVoxels(''sigma''); ', 'Separator', 'off');
uimenu(M.ui.sortMenu, 'Label', 'Sort Voxels by pRF size (sigma minor)', ...
	   'Callback', 'rmPlotGUI_sortVoxels(''sigmaminor''); ', 'Separator', 'off');

% select a subset of voxels
cb = ['rmPlotGUI_selectVoxels(gcf, [], 2); rmPlotGUI(''update''); '];
uimenu(M.ui.sortMenu, 'Label', 'Sub-select voxels', ...
	   'Callback', cb, 'Separator', 'off');

   
%% also add a help menu
helpMenu([], 'PRF_Tutorial');
% set(M.fig, 'MenuBar', 'figure');

return