function params = makeRing(params,id)
% makeRing - regular retinotopic 'ring' stimulus
%
% params = makeRing(params,id);
%
% largely copied from makeRetinotopyStimulus.
% params should be a retinotopy model parameter structure.
% id is the index of the stimulus (e.g., which scan in the data type is the
% ring scan we are constructing now?)
%
% 2010    KVH adapted so that it's now a periodic stimulus and also added
%             the option to mask out the center of the visual field (uses 
%             the mean luminance field in the rmparams form to indicate the
%             size of the central mask in deg)
% 2006/06 SOD

if notDefined('params');     error('Need params'); end;
if notDefined('id');         id = 1;               end;

fprintf(1,'[%s]:Creating images:',mfilename);

outerRad   = params.stim(id).stimSize;
ringWidth  = outerRad .* params.stim(id).stimWidth ./ 360;
numImages  = params.stim(id).nFrames ./ params.stim(id).nCycles;
mygrid     = -params.analysis.fieldSize:params.analysis.sampleRate:params.analysis.fieldSize; 	 
[x,y]      = meshgrid(mygrid,mygrid);
r          = sqrt (x.^2  + y.^2);
theta      = atan2 (y, x);	  
theta      = mod(theta,2*pi); 
startEcc   = outerRad .* (params.stim(id).stimStart / 360);

params.analysis.X = x(:);
params.analysis.Y = y(:);

images = zeros(prod([size(x,2) size(x,1)]),numImages);
for imgNum=1:numImages
    img     = zeros(size(x,2), size(x,1));
    loAngle = 0;
    hiAngle = 2*pi;
    
    loEcc   = mod((outerRad * (imgNum-1)/numImages) + startEcc, outerRad);
    hiEcc   = mod(loEcc + ringWidth, outerRad);
    
    if loEcc < hiEcc
        window = ( (theta>=loAngle & theta<hiAngle)  & ...
            ((r>=loEcc & r<=hiEcc)) & r<outerRad);
        img(window) = 1;
    else
        loEcc1 = 0; loEcc2 = loEcc;
        hiEcc1 = hiEcc; hiEcc2 = outerRad;
        
        window1 = ( (theta>=loAngle & theta<hiAngle)  & ...
            (r>=loEcc1 & r<=hiEcc1) );
        img(window1) = 1;
        
        window2 = ( (theta>=loAngle & theta<hiAngle)  & ...
            (r>=loEcc2 & r<=hiEcc2) );
        img(window2) = 1;        
    end

    if params.stim(id).nStimOnOff>0,
        mask = (theta>=loAngle & theta<hiAngle) & (r >= params.stim(id).nStimOnOff);
        img = img .* mask;
    end;

    images(:,imgNum) = img(:);
    fprintf('.'); drawnow;

end;

img = repmat(images,[1 params.stim(id).nCycles]);

preimg = img(:,1+end-params.stim(id).prescanDuration:end);
params.stim(id).images = cat(2, preimg, img);

fprintf(1,'Done.\n'); drawnow;

return;
