function h = gaborTestParams;
% Simple GUI which allows the user to test the effects of different
% parameters on a Gabor function.
%
% h = gaborTestParams;
%
% ras, 03/2008.

%% create a structure containing the parameters
% this will be kept in the main figure's UserData
[U.x U.y] = meshgrid(-64:64, -64:64);
U.kappa = pi;
U.theta = 0;
U.omega = 1;

%% create the figure
h = figure('Color', [.9 .9 .9], 'Units', 'norm', 'Position', [.3 .3 .5 .5], ...
			'NumberTitle', 'off', 'Name', 'Gabor Wavelet Test', ...
			'UserData', U);
colormap( mrvColorMaps('gray') );

%% create a slider for adjusting kappa
cb = ['U = get(gcf, ''UserData''); ' ...
	  'U.kappa = val;' ...
	  'set(gcf, ''UserData'', U); ' ...
	  'subplot(1, 2, 1); ' ...
	  'imagesc( real(gaborWavelet(U.x, U.y, U.theta, U.omega, U.kappa)), [-.5 .5] ); ' ...
	  'axis image; axis off; title(''Even''); ' ...
	  'subplot(1, 2, 2); ' ...
	  'imagesc( imag(gaborWavelet(U.x, U.y, U.theta, U.omega, U.kappa)), [-.5 .5] ); ' ...
	  'axis image; axis off; title(''Odd''); ' ...
	  'clear U '];
mrvSlider([.1 .05 .22 .08], 'kappa', 'Range', [0 10], 'FlexFlag', 1, ...
		  'Value', U.kappa, 'Callback', cb);

%% create a slider for adjusting omega
cb = ['U = get(gcf, ''UserData''); ' ...
	  'U.omega = 2*pi * val / 128;' ...
	  'set(gcf, ''UserData'', U); ' ...
	  'subplot(1, 2, 1); ' ...
	  'imagesc( real(gaborWavelet(U.x, U.y, U.theta, U.omega, U.kappa)), [-.5 .5] ); ' ...
	  'axis image; axis off; title(''Even''); ' ...
	  'subplot(1, 2, 2); ' ...
	  'imagesc( imag(gaborWavelet(U.x, U.y, U.theta, U.omega, U.kappa)), [-.5 .5] ); ' ...
	  'axis image; axis off; title(''Odd''); ' ...
	  'clear U '];
mrvSlider([.4 .05 .22 .08], 'omega (cycles/image)', 'Range', [0 10], 'FlexFlag', 1, ...
		  'Value', U.omega, 'Callback', cb);
	  
%% create a slider for adjusting theta
cb = ['U = get(gcf, ''UserData''); ' ...
	  'U.theta = deg2rad(val);' ...
	  'set(gcf, ''UserData'', U); ' ...
	  'subplot(1, 2, 1); ' ...
	  'imagesc( real(gaborWavelet(U.x, U.y, U.theta, U.omega, U.kappa)), [-.5 .5] ); ' ...
	  'axis image; axis off; title(''Even''); ' ...
	  'subplot(1, 2, 2); ' ...
	  'imagesc( imag(gaborWavelet(U.x, U.y, U.theta, U.omega, U.kappa)), [-.5 .5] ); ' ...
	  'axis image; axis off; title(''Odd''); ' ...
	  'clear U '];
mrvSlider([.7 .05 .22 .08], 'theta ()', 'Range', [0 180], 'FlexFlag', 1, ...
		  'Value', U.theta, 'Callback', cb);

%% Create the main axes; initial refresh
axes('Units', 'norm', 'Position', [.1 .2 .8 .65]);
% imagesc( real(gaborWavelet(U.x, U.y, U.theta, U.omega, U.kappa)), [-.5 .5] );
% axis image; axis off;
subplot(1, 2, 1); 
imagesc( real(gaborWavelet(U.x, U.y, U.theta, U.omega, U.kappa)), [-.5 .5] ); 
axis image; axis off; title('Even'); 
subplot(1, 2, 2); 
imagesc( imag(gaborWavelet(U.x, U.y, U.theta, U.omega, U.kappa)), [-.5 .5] ); 
axis image; axis off; title('Odd');

return
	  