function B = transform_image_LO_TO(I, corners, interporation)

% B = transform_image3(I, corners, interporation)
% calculate the transformation matrix for each area

B = nan(128,128);

if notDefined('interporation'), interporation = [];  end;

% LO1
input_points = corners{1};
% base_points =  [40 20;40 35; 80 35; 80 20];
base_points =  [30 80; 45 80; 45 40; 30 40];
udata = [1 121];  vdata = [1 121];  % input coordinate system
tform = maketform('projective',input_points, base_points);
[tmp,xdata,ydata] = imtransform(I,tform,interporation,'udata',udata,...
                                                'vdata',vdata,...
                                                'xdata',udata,...
                                                'ydata',vdata,...
                                                'size',size(I),...
                                                'fill',128);
                                            
B(round(20/120*128):round(100/120*128), round(20/120*128):round(45/120*128))=tmp(round(20/120*128):round(100/120*128),round(20/120*128):round(45/120*128));

% LO2
input_points = corners{2};
% base_points =  [40 50;40 35; 80 35; 80 50];
base_points =  [60 80; 45 80; 45 40; 60 40];
udata = [1 121];  vdata = [1 121];  % input coordinate system
tform = maketform('projective',input_points, base_points);
[tmp,xdata,ydata] = imtransform(I,tform,interporation,'udata',udata,...
                                                'vdata',vdata,...
                                                'xdata',udata,...
                                                'ydata',vdata,...
                                                'size',size(I),...
                                                'fill',128);
B(round(20/120*128):round(100/120*128), round(45/120*128):round(60/120*128))=tmp(round(20/120*128):round(100/120*128),round(45/120*128):round(60/120*128));

% TO1
input_points = corners{3};
% base_points =  [40 50;40 65; 80 65; 80 50];
base_points =  [60 80; 75 80; 75 40; 60 40];
udata = [1 121];  vdata = [1 121];  % input coordinate system
tform = maketform('projective',input_points, base_points);
[tmp,xdata,ydata] = imtransform(I,tform,interporation,'udata',udata,...
                                                'vdata',vdata,...
                                                'xdata',udata,...
                                                'ydata',vdata,...
                                                'size',size(I),...
                                                'fill',128);
                                            
B(round(20/120*128):round(100/120*128), round(60/120*128):round(75/120*128))=tmp(round(20/120*128):round(100/120*128),round(60/120*128):round(75/120*128));

% TO2
input_points = corners{4};
base_points =  [90 80; 75 80; 75 40; 90 40];
udata = [1 121];  vdata = [1 121];  % input coordinate system
tform = maketform('projective',input_points, base_points);
[tmp,xdata,ydata] = imtransform(I,tform,interporation,'udata',udata,...
                                                'vdata',vdata,...
                                                'xdata',udata,...
                                                'ydata',vdata,...
                                                'size',size(I),...
                                                'fill',128);
                                            
B(round(20/120*128):round(100/120*128), round(75/120*128):round(90/120*128))=tmp(round(20/120*128):round(100/120*128),round(75/120*128):round(90/120*128));

% TO2 side (for the control of noise average)
input_points = corners{6};
base_points =  [90 80; 105 80; 105 40; 90 40];
udata = [1 121];  vdata = [1 121];  % input coordinate system
tform = maketform('projective',input_points, base_points);
[tmp,xdata,ydata] = imtransform(I,tform,interporation,'udata',udata,...
                                                'vdata',vdata,...
                                                'xdata',udata,...
                                                'ydata',vdata,...
                                                'size',size(I),...
                                                'fill',128);
                                            
B(round(20/120*128):round(100/120*128), round(90/120*128):round(105/120*128))=tmp(round(20/120*128):round(100/120*128),round(90/120*128):round(105/120*128));

