function [atlasView, atlasTypeNum] = getAtlasView()
%
% [atlasView, atlasTypeNum] = getAtlasView()
%
% Author:  Brewer, Wandell
% Purpose:
%
% We check which of the currently open FLAT windows have dataTYPE set to
% Atlases-???'. If there is only one, then that FLAT view is returned. If
% there are none, an empty array is returned. If there is more than one,
% the user is prompted to select the figure showing the desired Atlas.
%
mrGlobals;
atlasViewList = {};

% Changed -- if createAtlas fails this could be the cause.
atlasTypeNum = existDataType('Atlases',[],0);

for(ii=1:length(FLAT))
    % strmatch will match if only the first part matches
    if(~isempty(FLAT{ii}) & strmatch('Atlases',getDataTypeName(FLAT{ii})))
        % These are the FLAT{} data structures with an Atlases type
        % selected.
        atlasViewList{end+1} = ii;
    end
end


if(isempty(atlasViewList))
    atlasView = [];
elseif(length(atlasViewList)==1)
    atlasView = FLAT{atlasViewList{1}};
else
    % More than one of the FLAT{} structures has an Atlases type selected.
    % We ask the user which of the FLAT{} structures they have in mind.
    % We figure this out by asking them to identify the figure number with
    % the selected atlas.  Then, we convert the figure number into the
    % index into the FLAT{} cell array.
    prompt={'Enter the figure number of the FLAT view showing the atlas'};
    def={'1'}; dlgTitle='Figure Showing Atlas'; lineNo=1;
    answer=inputdlg(prompt,dlgTitle,lineNo,def);
    atlasFig = str2num(answer{1});
    idx = fignum2FLATindex(atlasFig);
    if ~isempty(idx),  atlasView = FLAT{idx};
    else
        errordlg('Selected figure number does not have an Atlases data type.');
        atlasView = [];
    end
end


return;

