function rx = rxOpenInterp3ViewFig(rx);
%
%  rx = rxOpenInterp3ViewFig(rx);
%
% Open a figure to view interpolated prescription slices from
% 3 orientations (rows, cols, slices), rather than just slices.
%
% ras, 02/08/2008
javaFigs = mrvJavaFeature;

%% open the figure
rx.ui.interp3ViewFig = figure('Color', 'w', ...
                      'Name', 'mrRx Prescribed Slice 3-View', ...
                      'Units', 'Normalized', ...
                      'ButtonDownFcn', 'zoom', ...
                      'NumberTitle', 'off', ...
                      'MenuBar', 'none', ...
                      'Position', [.2 .2 .5 .5]);

				  
%% create axes				  
rx.ui.interp3ViewAxes(1) = axes('Position', [.5 0 .5 .5]);
rx.ui.interp3ViewAxes(2) = axes('Position', [.5 .5 .5 .5]);
rx.ui.interp3ViewAxes(3) = axes('Position', [0 .5 .5 .5]);

%% make UI controls
% make text labels for slice fields
uicontrol('Style', 'text', 'Units', 'norm', 'Position', [.15 .4 .12 .03], ...
		  'String', 'Row (Axial):', 'BackgroundColor', 'w');
uicontrol('Style', 'text', 'Units', 'norm', 'Position', [.15 .35 .12 .03], ...
		  'String', 'Column  (Coronal):', 'BackgroundColor', 'w');
uicontrol('Style', 'text', 'Units', 'norm', 'Position', [.15 .3 .12 .03], ...
		  'String', 'Slice  (Sagittal):', 'BackgroundColor', 'w');

% make slice fields
rx.ui.interpLoc(1) = uicontrol('Style', 'edit', 'Units', 'norm', ...
		  'Position', [.27 .4 .12 .03], 'BackgroundColor', 'w', ...
		  'String', num2str(round(rx.rxDims(1) / 2)), ...
		  'Callback', 'rxRefresh3View;');
rx.ui.interpLoc(2) = uicontrol('Style', 'edit', 'Units', 'norm', ...
		  'Position', [.27 .35 .12 .03], 'BackgroundColor', 'w', ...
		  'String', num2str(round(rx.rxDims(2) / 2)), ...
		  'Callback', 'rxRefresh3View;');
rx.ui.interpLoc(3) = uicontrol('Style', 'edit', 'Units', 'norm', ...
		  'Position', [.27 .3 .12 .03], 'BackgroundColor', 'w', ...
		  'String', num2str(round(rx.rxDims(3) / 2)), ...
		  'Callback', 'rxRefresh3View;');
	    
% add arrow buttons to step through slices
cb = ['TMP = get(gcbo, ''UserData''); ' ...
	  'EDITFIELD = TMP(1); OFFSET = TMP(2); ' ...
	  'VAL = str2num(get(EDITFIELD, ''String'')); ' ...
	  'set(EDITFIELD, ''String'', num2str(VAL+OFFSET)); ' ...
	  'rxRefresh3View; clear VAL TMP EDITFIELD OFFSET '];
uicontrol('Style', 'pushbutton', 'Callback', cb, 'String', '<<',...
		  'Units', 'norm', 'Position', [.39 .4 .03 .03], ...
		  'UserData', [rx.ui.interpLoc(1) -1]);
uicontrol('Style', 'pushbutton', 'Callback', cb, 'String', '>>',...
		  'Units', 'norm', 'Position', [.45 .4 .03 .03], ...
		  'UserData', [rx.ui.interpLoc(1) +1]);
uicontrol('Style', 'pushbutton', 'Callback', cb, 'String', '<<',...
		  'Units', 'norm', 'Position', [.39 .35 .03 .03], ...
		  'UserData', [rx.ui.interpLoc(2) -1]);
uicontrol('Style', 'pushbutton', 'Callback', cb, 'String', '>>',...
		  'Units', 'norm', 'Position', [.45 .35 .03 .03], ...
		  'UserData', [rx.ui.interpLoc(2) +1]);
uicontrol('Style', 'pushbutton', 'Callback', cb, 'String', '<<',...
		  'Units', 'norm', 'Position', [.39 .3 .03 .03], ...
		  'UserData', [rx.ui.interpLoc(3) -1]);
uicontrol('Style', 'pushbutton', 'Callback', cb, 'String', '>>',...
		  'Units', 'norm', 'Position', [.45 .3 .03 .03], ...
		  'UserData', [rx.ui.interpLoc(3) +1]);	  
	  
% add a zoom button for convenience
uicontrol('Style', 'pushbutton', 'Callback', 'zoom', 'String', 'Zoom',...
		  'Units', 'norm', 'Position', [.24 .25 .12 .03], ...
		  'BackgroundColor', [.9 .9 .9]);	  

	  
% add a checkbox to switch to comparison mode
rx.ui.interp3ViewCompare = uicontrol('Style', 'checkbox', ...
		  'String', 'Compare Interp / Ref', 'Value', 0, ...
		  'Units', 'norm', 'Position', [.24 .20 .2 .03], ...
		  'BackgroundColor', [1 1 1], ...
		  'Callback', 'rxRefresh3View();');


	  

%-------------------------------------------
% Toggles - switch between interp/reference 
%------------------------------------------

% add a toggle button for all views 
uicontrol('Style', 'pushbutton', 'String', 'Toggle All', ...
		  'Units', 'norm', 'Position', [.27 .15 .12 .03], ...
		  'BackgroundColor', [1 1 1], ...
		  'Callback', 'rx3ViewToggle([], str2num(get(rx.ui.toggle, ''String'')));');

% add a toggle button for window 1
uicontrol('Style', 'pushbutton', 'String', 'Toggle1', ...
          'Units', 'norm', 'Position', [.24 .10 .06 .03], ...
          'BackgroundColor', [1 1 1], ...
          'Callback', 'rx3ViewToggle([], str2num(get(rx.ui.toggle, ''String'')), 1);');

% add a toggle button for window 2
uicontrol('Style', 'pushbutton', 'String', 'Toggle2', ...
          'Units', 'norm', 'Position', [.30 .10 .06 .03], ...
          'BackgroundColor', [1 1 1], ...
          'Callback', 'rx3ViewToggle([], str2num(get(rx.ui.toggle, ''String'')), 2);');

% add a toggle button for window 3
uicontrol('Style', 'pushbutton', 'String', 'Toggle3', ...
          'Units', 'norm', 'Position', [.36 .10 .06 .03], ...
          'BackgroundColor', [1 1 1], ...
          'Callback', 'rx3ViewToggle([], str2num(get(rx.ui.toggle, ''String'')), 3);');

% number of toggles
rx.ui.toggle = uicontrol('Style', 'edit', 'Units', 'norm', ...
		  'Position', [.36 .05 .06 .03], 'BackgroundColor', 'w', ...
		  'String', num2str(3));
      
uicontrol('Style', 'text', 'Units', 'norm', 'Position', [.24 .05 .12 .03], ...
		  'String', 'num toggles:', 'BackgroundColor', 'w'); 
      
% % make brightness and contrast sliders (disabled)
% rx.ui.interpBright = rxMakeSlider('Brightness', [0 1], ...
%                              [.35 .02 .3 .1],0,0.5);
% rx.ui.interpContrast = rxMakeSlider('Contrast', [0 1], ...
%                              [.68 .02 .3 .1],0,0.5);  
% 
% % make a contrast auto-threshold checkbox as well
% rx.ui.interpHistoThresh = uicontrol('Style',  'checkbox',  ...
%                         'String',  'Auto-contrast',  ...
%                         'Units',  'normalized',  ...
%                         'Position',  [.05 .05 .25 .05],  ...
%                         'FontSize',  10, 'BackgroundColor',  'w',  ...
%                         'Value',  0, 'Callback',  'rxRefresh;');                         				
					
%% add menus 
rx.ui.interp3ViewMenu = uimenu('Label', 'AC/PC');

% set AC
uimenu(rx.ui.interp3ViewMenu, 'Label', 'Set Anterior Commissure', ...
		'Callback', 'rxSetACPC([], 1);', 'Accelerator', '1');
% set PC
uimenu(rx.ui.interp3ViewMenu, 'Label', 'Set Posterior Commissure', ...
		'Callback', 'rxSetACPC([], 2);', 'Accelerator', '2');
% set Mid-Sag
uimenu(rx.ui.interp3ViewMenu, 'Label', 'Set Mid-Sagittal Point', ...
		'Callback', 'rxSetACPC([], 3);', 'Accelerator', '3');

% find AC
uimenu(rx.ui.interp3ViewMenu, 'Label', 'Find Anterior Commissure', ...
		'Separator', 'on', 'Callback', 'rxGetACPC([], 3, 1);', 'Accelerator', '4');
% find PC
uimenu(rx.ui.interp3ViewMenu, 'Label', 'Find Posterior Commissure', ...
		'Callback', 'rxGetACPC([], 3, 2);', 'Accelerator', '5');
% find Mid-Sag
uimenu(rx.ui.interp3ViewMenu, 'Label', 'Find Mid-Sagittal Point', ...
		'Callback', 'rxGetACPC([], 3, 3);', 'Accelerator', '6');
% list points
uimenu(rx.ui.interp3ViewMenu, 'Label', 'List AC/PC Points', ...
		'Callback', 'rxGetACPC([], 2);');
	

rxComparePrefsMenu(gcf);
	
mrvJavaFeature(javaFigs);


%% give it an initial refresh
rxRefresh3View(rx);

return
