function view = installTalairachCoordinates(view);
%loadTalairachCoordinates() Load Tal. coordinates from file and convert the
%to Volume ROIs
%The Gray (Volume) window must be open.
%
% Authors RFD and JR 09/18/01
% 2002.01.17 RFD modified initialization to allow GRAY view as well as
% volume.

global mrSESSION



if ~strcmp(view.viewType,'Volume') & ~strcmp(view.viewType,'Gray');

    error('view must be VOLUME or GRAY')

end



transform = loadTalairachXform(mrSESSION.subject);

talDat = loadTalairachCoordinates;

xyz=[talDat{1}',talDat{2}',talDat{3}'];

roiNames = cellstr(talDat{4});

roiColors = cellstr(talDat{5});  



% Let the user select from the available coords

[idx,ok] = listdlg('PromptString','Select Talairach coordinates',...

       'SelectionMode','multiple',...

       'ListString',roiNames);

if ~ok %user has aborted selection

    return

end

xyz=xyz(idx,:);

roiNames=roiNames(idx);

roiColors=roiColors(idx);



vCoords = talairachToVol(xyz, transform.vol2Tal);



for(ii=[1:size(vCoords,1)])

    view = newROI(view, roiNames{ii}, 1, roiColors{ii});

    view.ROIs(view.selectedROI).coords = round(vCoords(ii,:))';

%     roi.name = roiNames{ii};%['Talairach_',num2str(tc(ii,1)),'_',num2str(tc(ii,2)),'_',num2str(tc(ii,3)),''];

%     roi.coords = round(vCoords(ii,:))';

%     roi.color = roiColors{ii};

%     roi.viewType = view.viewType;

%     view = addROI(view,roi);

end

