function writeVFileSet(dataToWrite,fileRoot)
%Writes matrix of (nFrames*x*y*nSlices) as nFrames files each of size
%x*y(nSlices)
%
%   writeVFileSet(dataToWrite,fileRoot)
% 
% Also incorporates stuff like voxel size
% ARW 101601
% JL updated 091704

% We get the mm/vox from mrSESSION
mrGlobals;

[nVols,x,y,nSlices]=size(dataToWrite);

if isfield(mrSESSION,'mrLoadRetVersion');
    if mrSESSION.mrLoadRetVersion >= 3;
        mmPerVox = mrSESSION.functionals(viewGet(INPLANE{1},'curScan')).voxelSize; %#ok<USENS>
    end
else
    mmPerVox=mrSESSION.voxelSize.*[2 2 1]; % Double the effective mmPerVox 'cos mrSESSION lists the interpolated mmPerVox
end

img_dim=[x,y,nSlices]; % THis is each volume size : x*y*nSlices . The '4' refers to the spm data type 'uint16' : see spm_type

% Now we have to write out a header file and an image file. 
% We write out the header using the SPM command spm_write_vol
% We dump out the image data as int16s 

% Use spm_hwrite to write the header.
% FORMAT [s] = spm_hwrite(P,DIM,VOX,SCALE,TYPE,OFFSET,ORIGIN,DESCRIP);
newimg =zeros(x,y,nSlices); %#ok<NASGU>

if ~strcmp(fileRoot(end),filesep)
    fileRoot = [fileRoot, filesep];
end

for thisVol=0:nVols-1
    
    newimg = squeeze(dataToWrite(thisVol+1,:,:,:));
    
    nHundreds= fix(thisVol/100);
    nTens    = fix(fix(thisVol-100*nHundreds)/10);
    nOnes    = mod(thisVol,10);
    
    thisFileName=[fileRoot,int2str(nHundreds),int2str(nTens),int2str(nOnes)];
        
    s=spm_hwrite([thisFileName,'.hdr'],img_dim,mmPerVox,1,spm_type('int16'),0);
    if s~=348; error('Error writing hdr files'); end;
    V=spm_vol([thisFileName,'.img']);
    
    if isfield(mrSESSION,'mrLoadRetVersion');
        if mrSESSION.mrLoadRetVersion >= 3;
            V.descrip=['Converted from tSeries file in session',mrSESSION.sessionCode,' : ',dataTYPES(viewGet(INPLANE{1},'curDataType')).name,':  on ',datestr(now)];
        end
    else
        V.descrip=['Converted from tSeries file in session',mrSESSION.homeDir,' : ',mrSESSION.types(mrSESSION.curType).name,':  on ',datestr(now)];
    end
    fprintf('\n%d',thisVol);
    
    spm_write_vol(V,newimg);
end
return;

%------------------------------------------------------------------- 

function [s] = spm_hwrite(P,DIM,VOX,SCALE,TYPE,OFFSET,ORIGIN,DESCRIP)
% writes a header
% FORMAT [s] = spm_hwrite(P,DIM,VOX,SCALE,TYPE,OFFSET,ORIGIN,DESCRIP);
%
% P       - filename 	     (e.g 'spm' or 'spm.img')
% DIM     - image size       [i j k [l]] (voxels)
% VOX     - voxel size       [x y z [t]] (mm [sec])
% SCALE   - scale factor
% TYPE    - datatype (integer - see spm_type)
% OFFSET  - offset (bytes)
% ORIGIN  - [i j k] of origin  (default = [0 0 0])
% DESCRIP - description string (default = 'spm compatible')
%
% s       - number of elements successfully written (should be 348)
%___________________________________________________________________________
%
% spm_hwrite writes variables from working memory into a SPM/ANALYZE
% compatible header file.  The 'originator' field of the ANALYZE format has
% been changed to ORIGIN in the SPM version of the header. funused1
% of the ANALYZE format is used for SCALE
%
% see also dbh.h (ANALYZE) spm_hread.m and spm_type.m
%
%__________________________________________________________________________
% @(#)spm_hwrite.m	2.3 00/02/22


% ensure correct suffix {.hdr} and open header file
%---------------------------------------------------------------------------
P               = deblank(P);
q    		= length(P);
if q>=4 && P(q - 3) == '.', P = P(1:(q - 4)); end;
P     		= [P '.hdr'];

% For byte swapped data-types, also swap the bytes around in the headers.
mach = 'native';
if spm_type(TYPE,'swapped'),
	if spm_platform('bigend'),
		mach = 'ieee-le';
    else
		mach = 'ieee-be';
	end;
	TYPE = spm_type(spm_type(TYPE));
end;
fid             = fopen(P,'w',mach);

if (fid == -1),
	error(['Error opening ' P '. Check that you have write permission.']);
end;
%---------------------------------------------------------------------------
data_type 	= ['dsr      ' 0];

P     		= [P '                  '];
db_name		= [P(1:17) 0];

% set header variables
%---------------------------------------------------------------------------
DIM		= DIM(:)'; if size(DIM,2) < 4; DIM = [DIM 1]; end
VOX		= VOX(:)'; if size(VOX,2) < 4; VOX = [VOX 0]; end
dim		= [4 DIM(1:4) 0 0 0];	
pixdim		= [0 VOX(1:4) 0 0 0];
vox_offset      = OFFSET;
funused1	= SCALE;
glmax		= 1;
glmin		= 0;
bitpix 		= 0;
descrip         = zeros(1,80);
aux_file        = ['none                   ' 0];
origin          = [0 0 0 0 0];

%---------------------------------------------------------------------------
if TYPE == 1;   bitpix = 1;  glmax = 1;        glmin = 0;	end
if TYPE == 2;   bitpix = 8;  glmax = 255;      glmin = 0;	end
if TYPE == 4;   bitpix = 16; glmax = 32767;    glmin = 0;  	end
if TYPE == 8;   bitpix = 32; glmax = (2^31-1); glmin = 0;	end
if TYPE == 16;  bitpix = 32; glmax = 1;        glmin = 0;	end
if TYPE == 64;  bitpix = 64; glmax = 1;        glmin = 0;	end

%---------------------------------------------------------------------------
if nargin >= 7; origin = [ORIGIN(:)' 0 0];  end
if nargin <  8; DESCRIP = 'spm compatible'; end

d          	= 1:min([length(DESCRIP) 79]);
descrip(d) 	= DESCRIP(d);

fseek(fid,0,'bof');

% write (struct) header_key
%---------------------------------------------------------------------------
fwrite(fid,348,		'int32');
fwrite(fid,data_type,	'char' );
fwrite(fid,db_name,	'char' );
fwrite(fid,0,		'int32');
fwrite(fid,0,		'int16');
fwrite(fid,'r',		'char' );
fwrite(fid,'0',		'char' );

% write (struct) image_dimension
%---------------------------------------------------------------------------
fseek(fid,40,'bof');

fwrite(fid,dim,		'int16');
fwrite(fid,'mm',	'char' );
fwrite(fid,0,		'char' );
fwrite(fid,0,		'char' );

fwrite(fid,zeros(1,8),	'char' );
fwrite(fid,0,		'int16');
fwrite(fid,TYPE,	'int16');
fwrite(fid,bitpix,	'int16');
fwrite(fid,0,		'int16');
fwrite(fid,pixdim,	'float');
fwrite(fid,vox_offset,	'float');
fwrite(fid,funused1,	'float');
fwrite(fid,0,		'float');
fwrite(fid,0,		'float');
fwrite(fid,0,		'float');
fwrite(fid,0,		'float');
fwrite(fid,0,		'int32');
fwrite(fid,0,		'int32');
fwrite(fid,glmax,	'int32');
fwrite(fid,glmin,	'int32');

% write (struct) image_dimension
%---------------------------------------------------------------------------
fwrite(fid,descrip,	'char');
fwrite(fid,aux_file,    'char');
fwrite(fid,0,           'char');
fwrite(fid,origin,      'int16');
if fwrite(fid,zeros(1,85), 'char')~=85
	fclose(fid);
	spm_unlink(P);
	error(['Error writing ' P '. Check your disk space.']);
end

s   = ftell(fid);
fclose(fid);
