function [imBlock,hdr]=dicom2analyze(fileHead,nIms,analyzeFilename,startIndex,suffix,zeroPadding)
% [imBlock,hdr]=dicom2analyze(fileHead,nIms,analyzeFilename,startIndex,suffix,zeroPadding)
% DCM files generated by the scanners at china basin appear to have a
% strange filename numbering system. 
% We want to stack them all together into a block for processing as
% anatomical volumes in analyze format. 
% To do this , we need to delve deep into the header info and re-order the
% images.....
% Uses the matlab DICOM routines. These need to be patched using an updater
% from the matlab website. http://www.mathworks.com
% Do a 'support' search for DICOM.

disp('**** WARNING ... YOU MUST CHECK THE PIXEL SIZES IN THE HEADER AFTER RUNNING THIS FUNCTION ****');
disp('** HIT ANY KEY TO CONTINUE ***');
pause

warning off Images:genericDICOM

if (ieNotDefined('startIndex'))
    startIndex=1;
end
if (ieNotDefined('suffix'))
    suffix='.DCM';
end
if (ieNotDefined('zeroPadding'))
    zeroPadding=0;
end 
% Should be run from inside the directory containing the DCM files

endIndex=startIndex+nIms-1;

% Read in the first image to get some info about sizes (orientations?)
% etc...
thisIm=1;

formatString=['%0.',int2str(zeroPadding),'d'];

thisFile=[fileHead,sprintf(formatString,thisIm+startIndex'),suffix];
 
thisFileInfo=dicominfo(thisFile);
nRows=thisFileInfo.Rows;
nCols=thisFileInfo.Columns;

% This could be gleaned from the DICOM header as well. And should be.


imBlock=zeros(nIms,nCols,nRows);

counter=1;
for thisIm=startIndex:endIndex
thisFile=[fileHead,sprintf(formatString,thisIm'),suffix];
thisFileInfo=dicominfo(thisFile);
sliceLoc(counter)=thisFileInfo.SliceLocation;

    [a,b]=dicomread(thisFile);
    imBlock(counter,:,:)=a;
    counter=counter+1;
    fprintf('.');
    
end
 
% Slices are in a semi-random order that needs to be fixed. We can do this
% based on the SliceLocation field of the DICOM header.

[i,j]=sort(sliceLoc); % This should be unique

% Now make a better stack
imBlock=imBlock(j,:,:); % The assumption is that there is a constant inter-slice spacing. If this fails, then all bets are off and you need to do some interpolation. Ughh..
imBlock=permute(imBlock,[3,2,1]);
nSlices=size(imBlock,3);

disp('Rotating');
for t=1:nSlices
    disp('.');
    imBlock(:,:,t)=rot90(imBlock(:,:,t),2);
end

%check it
f=squeeze(imBlock(:,100,:));
imagesc(f);
colormap gray
 
% Finally, dump it out in analyze format using spm_writevol
mmPerVox=[thisFileInfo.PixelSpacing(1), thisFileInfo.PixelSpacing(2),thisFileInfo.SliceThickness];
notes='Converted from Dicom';

saveAnalyze(imBlock,analyzeFilename, mmPerVox, notes); % This is a stanford function. But it basically calls spm_writevol
hdr.mmPerVox=mmPerVox;
hdr.notes=notes;
hdr.dcHeader=thisFileInfo;
return;
