function analyze2Class(inputImg,outFile);
% analyze2Class(inputImg,outFile);
%
% an attempt to patch together a functional .class file from segmentations
% generated by surfRelax / FSL. 
%
% The inputImg should be an ANALYZE file the same size as the
% vAnatomy, with different values specifying gray, white, and
% csf. (If there's only one value, it assumes this is white.)
% Outputs a class struct.
%
% ras 11/03
if ~exist('inputImg','var') | isempty(inputImg)
    [imgFile,imgPath] = myUIGetFile(fullfile(RAID,'3DAnat','Ifiles'),...
                            '*.img','Choose an Analyze image');
    inputImg = fullfile(imgPath,imgFile);
end

if ~exist(inputImg,'file')
    error(sprintf('Couldn''t find %s.\n',inputImg));
end

if ~exist('outFile','var')
    outFile = [inputImg(1:end-4) '.class'];
end

type.unknown = 0;
type.white = 16;
type.gray = 32;
type.csf = 48;

% load data from the analyze file
[data,mmPerVox,hdr] = loadAnalyze(inputImg);

% assign values in the analyze image
% to the class volume:
% This is tricky, since I'd like to 
% use this at different stages of the 
% process (for instance, FSL's BET program
% produces a segmentation with three values,
% corresponding to csf, gray, and white; while
% Jonas' SegmentHemispheres corresponds to 
% white only). Use a heuristic:
vals = unique(data);
nvals = length(vals);
switch nvals
    case 2,
        % assume WM + GM
        matter = [16 32];
        for i = 1:nvals
            data(find(data==vals(i))) = matter(i);
        end
    case 3, 
        % assume CSF + GM + WM (FSL order)
        matter = [48 32 16];
        for i = 1:nvals
            data(find(data==vals(i))) = matter(i);
        end
    otherwise,
        % assume all WM
        data(find(data)) = 16;
end
        
szX = size(data,3);
szY = size(data,2);
szZ = size(data,1);

% flip axes to agree with mrGray conventions
fprintf('Permuting axes to mrGray format...\n');
newdata = zeros(size(data));
for i = 1:size(data,2)
    newdata(:,end-(i-1),:) = (squeeze(data(:,i,:)));
end
data = newdata;
data = permute(data,[3 2 1]);
newdata = [];
for i = 1:size(data,3);
    newdata(:,:,i) = flipud(data(:,:,i))';
end
data = newdata;

hdr.version = 2;
hdr.minor = 1;
hdr.voi = [1 szX 1 szY 1 szZ];
hdr.xsize = szX;
hdr.ysize = szY;
hdr.zsize = szZ;
hdr.params = [0 1 240 4 0 0];

[a b] = fileparts(outFile);
class.filename = b;
class.type = type;
class.header = hdr;
class.data = data;

writeClassFile(class,outFile);
fprintf('Wrote file %s from info in file %s.\n',outFile,inputImg);

return