function [maxInRow,vals,count] = inARow(vec);
% INAROW: counts the max number of times each value in a vector occurs in a row, one after the other.
% Usage: [maxInRow,vals,count] = inARow(vec);
% E.g. suppose we have the following vector:
% 
%	1 1 1 3 1 1 2 2 2 2 3 1 
% 	
% The value '1' is repeated up to three times in a row in this vector, '2' up to four times in a row, and 
% '3' only once in a row -- it's never repeated. The output for this vector would therefore be: 
%
%	3 4 1
%
% indicating the max. number of times in a row each value had occurred.
%
% 'maxInRow' contains the max repeat numbers shown above.
% 'vals' contains the corresponding value in vec for each max repeat value.
% 'count' records how many times each value was repeated the max times.
% 
% 11/02 by ras
N = length(vec);
repNumVec = seqrepeats(vec);
vals = unique(vec);
for i = 1:length(vals)
	Ind = find(vec==vals(i));
	maxInRow(i) = max(repNumVec(Ind));
	count(i) = length(find(repNumVec(Ind)==maxInRow(i)));
end

return
