%% I. Set up fibersDir, dtDir andd roisDir for each participant 

subs = {'ab0','ad0','ada0','ajs0','am0','an0','ao0','ar0','bg0','ch0',...
    'clr0','cp0','crb0','ctb0','ctr0','da0','dh0','dm0','es0','hy0','jh0',...
    'jt0','kj0','ks0','lg0','ll0','mb0','mn0','nad0','nf0','nid0','pf0',...
    'pt0','rd0','rs0','rsh0','sg0','sl0','sy0','tk0','tm0','tv0','vh0',...
    'vr0','vt0','zs0','at0','js0','md0','mh0','mho0','mm0','rh0','ss0'};

% Sort the subject to they're in alphabetical order. 
subs = sort(subs);

baseDir = '/biac3/wandell4/data/reading_longitude/dti_y1/';

dirs    = 'dti06trilinrt';

fiberName = {'scoredFG_STS__border1008to1031node3_CC_clipRight_top1000_cleaned.pdb',...
               'scoredFG_STS_STSnode4_CC_clipRight_top1000_cleaned.pdb'...
               'scoredFG_STS_LpOTS_y1_funcBasedSphere5mm_CC_clipRight_top1000_cleaned.pdb'...
               'scoredFG_MTproject_100k_200_5_top1000_LEFT_clean_hom.pdb'};
           
           % Do THIS ABOVE for the core fiber!

rois      = {'AngularGyrus','STSnode4','LpOTS_y1_funcBasedSphere5mm','LMT'}; 

% fiberName = {'scoredFG_STS_LpOTS_y1_funcBasedSphere5mm_CC_clipRight_top1000_cleaned.pdb'}; 
% 
% rois      = {'LpOTS_y1_funcBasedSphere5mm'}; 

            % These ROIs (1 2) are in dti06trilinrt/ROIs
            % ROI 3 is in *subName*/ROIs/VWFA
            % ROI 4 is in dti_y1_old/*subname*/ROIs/MTproject/

%% II. Set up parameters
numberOfNodes      = 50; 
propertyofinterest = {'fa','md', 'rd', 'ad'};
fgName             = fiberName; 
numsfgs            = length(fiberName); 
roi1name           = rois; 
roi2name           = 'CC_clipRight.mat';

%% III Loop.
for zz = 1:numel(propertyofinterest)
    for kk = 1:numel(fiberName)
        if kk ==3
        end
        for ii=1:numel(subs)
            sub      = dir(fullfile(baseDir,[subs{ii} '*']));
            subDir   = fullfile(baseDir,sub.name);
            dt6Dir   = fullfile(subDir,dirs);
            fiberDir = fullfile(dt6Dir,'fibers','conTrack');
            roiDir   = fullfile(dt6Dir,'ROIs');
            try
                % III. 1 LOAD THE DATA
                fibersFile = fullfile(fiberDir, fgName{kk});
                if exist(fibersFile,'file')
                    fg = mtrImportFibers(fibersFile);
                else
                    disp(['File: ' fibersFile ' does not exist.']);
                end
                
                % Switch for ROIs in different locations.
                switch kk
                    case 1
                        rDir = roiDir;
                    case 2
                        rDir = roiDir;
                    case 3 
                        rDir = fullfile(subDir,'ROIs','VWFA');
                    case 4
                        bd = '/biac3/wandell4/data/reading_longitude/dti_y1_old/';
                        rDir   = fullfile(bd,sub.name,'ROIs','MTproject');
                end
                
                roi1File   = fullfile(rDir, [roi1name{kk} '.mat']);
                roi2File   = fullfile(roiDir, roi2name);
                roi2       = dtiReadRoi(roi1File);
                roi1       = dtiReadRoi(roi2File);
                dt         = dtiLoadDt6(fullfile(dt6Dir,'dt6.mat'));

                % III. 2 Compute
                [fa(:, ii),md(:, ii),rd(:, ii),ad(:, ii),cl(:, ii), SuperFibersGroup(ii), fgc]=...
                    dtiComputeDiffusionPropertiesAlongFG(fg, dt, roi1, roi2, numberOfNodes);
            catch ME
                fa(:, ii)=nan;md(:, ii)=nan;rd(:, ii)=nan;ad(:, ii)=nan;cl(:, ii)=nan;
                disp(ME);
                disp(['PROBLEM with subject: ' subs{ii} '. This subject will have nans!']);
            end
        end
        % LOOP OVER THIS to make it faster. 
%         for zz = 1:numel(propertyofinterest) %%%
            dtval.(propertyofinterest{zz}).(rois{kk}) = eval(propertyofinterest{zz});
%         end %%%
    end
end

disp('DONE!!!');

return

%% PLOT DATA
saveDir = '/biac4/wandell/biac3/wandell4/data/reading_longitude/STS_Project/Figures_2012';
if ~exist(saveDir,'file'), mkdir(saveDir); end

save((fullfile(saveDir,'dtval_0504_alphaSort.mat')),'dtval');    
    

%% VI Plot results for each fiber group sorted by subject

% Eval subs first.
load(fullfile(saveDir,'dtval_0430.mat'));
numberOfNodes      = 50; 
propertyofinterest = {'fa' ,'md', 'rd', 'ad'};
rois      = {'AngularGyrus','STSnode4','LpOTS_y1_funcBasedSphere5mm','LMT'}; 
label      = {'AngularGyrus','STS','VWFA','LMT'}; % This names the graph (should be the same as line 15)
col                = jet(numel(subs)); % set colors for graph.

for zz = 1:numel(propertyofinterest) % fa,md,rd,ad
    for kk = 1:numel(rois)
        
        AVG = nanmean(dtval.(propertyofinterest{zz}).(rois{kk}),2);
        % Could plot the variance, etc. of our data in addition to the
        % average. 
        figure;
        hold on
        % Loop over each subject and plot their data using a different color line (col)
        for ss = 1:numel(subs)
            plot(dtval.(propertyofinterest{zz}).(rois{kk})(:,ss),'color',[.8 .8 .8]);
        end
        
        switch kk
            case 1
                plot(AVG,'b','LineWidth',7);
            case 2
                plot(AVG,'r','LineWidth',7);
            case 3 
                plot(AVG,'m','LineWidth',7);
            case 4
                plot(AVG,'g','LineWidth',7);
        end
                
        set(gca,'PlotBoxAspectRatio',[1,.7,1]);
        set(gca,'FontName','Bookman');
        
        switch propertyofinterest{zz}
            case 'fa'
                yText = 'FA (weighted)';
                titleText = ['Fractional Anisotropy Along ' label{kk}];
            case 'md'
                yText = 'MD \mum^2/msec (weighted)';
                titleText = ['Mean Diffusivity Along ' label{kk}];
            case 'rd'
                yText = 'RD \mum^2/msec (weighted)';
                titleText = ['Radial Diffusivity Along ' label{kk}];
            case 'ad'
                yText = 'AD \mum^2/msec (weighted)';
                titleText = ['Axial Diffusivity Along ' label{kk}];
        end

        title(titleText);
        ylabel(yText);
        
        % This depends on the specific measure
        switch zz
            case 1 % FA
               axis([0 50 0 1]);
            case 2 % MD
               axis([0 50 0.5 1.5]);
            case 3 % RD
                axis([0 50 0 1]);
            case 4 % AD
                axis([0 50 .5 2.5]);
        end

        % [0 50 0 1] FA
        % [0 50 0 1] FA
        % [0 50 0 1] FA
        % [0 50 0 1] FA
        xlabel('Fiber Group Trajectory');
        set(gca,'xtick',[0 numberOfNodes]);
        set(gca,'xticklabel',{'Callosum',label{kk}});
        saveName = [rois{kk} '_' propertyofinterest{zz}];
        saveas(gcf,(fullfile(saveDir,saveName)),'epsc2');
    end
end


    

    
%% Plot VII Correlation Matrix
   
% saveDir = '/white/u8/lmperry/Desktop/DTI_figures_STS/dtvalByNodeSorted';
% if ~exist(saveDir,'file'), mkdir(saveDir); end
% 
% rois  = {'STSnode2','STSnode3','STSnode4','STSnode5'};
% c = {'2','3','4','5'};
% 
% for ii = 1:numel(rois)
%     dati = ['fas' c{ii}];
%     r = corr(eval(dati)');  
%     
%     figure; imagesc(r);
%         title(['Correlation Matrix for ' (rois{ii})]);
%         xlabel('Bin Number');
%         ylabel('Bin Number');
%         colorbar;
%     figure; plot(r(1,:), 'x');
%     title(['Bin Correlations for' (rois{ii})]);
%         xlabel('Bin Number');
%         ylabel('r Value');
% end
%     
%     
    
%     
%       r = corr(fas2');  
%     
%     figure; imagesc(r);
%         title('Correlation Matrix');
%         xlabel('Bin Number');
%         ylabel('Bin Number');
%         colorbar;
%     figure; plot(r(1,:), 'x');
%     title('Bin Correlations');
%         xlabel('Bin Number');
%         ylabel('r Value');
%     
%         
% 
%     
%     
    
    
    
    
    
    
    
    
    
    
    
